/*
  main.cpp - A sample KControl Application

  written 1997 by Matthias Hoelzer
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */
 
#include "main.h"
#include "dhcp.h"

DhcpApplication::DhcpApplication(int &argc, char **argv, char *name)
  : KControlApplication(argc, argv, name)
{
  dhcpapp = 0;

  if (runGUI())
    {
      if (!pages || pages->contains("Dhcp"))
        addPage(dhcpapp = new DhcpWidget(dialog, "dhcp"), i18n("&Dhcp Manager"), "index.html");
      dialog->show();
    }
}


void DhcpApplication::init()
{
}


void DhcpApplication::apply()
{
  if (dhcpapp)
    dhcpapp->applySettings();
}


int main(int argc, char **argv)
{
  DhcpApplication app(argc, argv, "kcmdhcp");

  app.setTitle(i18n("Dhcp Manager"));

  if (app.runGUI())
    return app.exec();
  else
    return 0;
}

