/***************************************************************************
                          parser.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 1999                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef __parser_h_included__
#define __parser_h_included__

#include <qstring.h>
#include <qstrlist.h>
#include "server.h"

class Parser
{
public:
 Parser();
 ~Parser();

 void ReadConfig(QString);
 void WriteConfig();
 void SearchCFile();
 void defaults(int);

 QString CFileName();
 void setCFileName(QString);

 int ExpireTime();
 server getServer(int i);

 int MaxFetch();
 int InitialFetch();
 int DelayBody();
 int MaxCrossPost();
 int MaxAge();
 int MaxLines();
 int MinLines();
 int MaxBytes();
 int TimeoutShort();
 int TimeoutLong();
 int TimeoutActive();
 int CreateLinks();
 QString Hostname();
 QStrList UTags();

 QStrList ExpireGroups();
 QStrList ExpireTimes();

private:
 QString DelSpace(QString);
 int pars(QString);

 QString cfilename;
 int expire;

 server serv[10];

 int acserv;

 int max_fetch;
 int initial_fetch;
 int delay_body;
 int max_cross;
 int max_age;
 int max_lines;
 int min_lines;
 int max_bytes;
 int timeout_short;
 int timeout_long;
 int timeout_active;
 int create_links;
 QStrList groupex, extime;
 QString hostn;

 QStrList utags;
};

#endif
