#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "aliasPage.h"
#include "aliasPage.moc"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "ircApp.h"

AliasPage::AliasPage(IrcAlias* Alias, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  alias = Alias;
  aliasPath = Alias->getPath();
  QHBoxLayout* horLayout = new QHBoxLayout(this, 10);
  QGroupBox*          gb = new QGroupBox("Alias", this);
  horLayout->addWidget(gb);

  QVBoxLayout* vbox=new QVBoxLayout(gb, 10);
  QHBoxLayout* hbox=new QHBoxLayout(5);
  vbox->addSpacing(gb->fontMetrics().height());
  vbox->addLayout(hbox);

  lePath = new QLineEdit(gb);
  hbox->addWidget(lePath, 10);

  lePath->setText("");
  QPushButton* btn = new QPushButton(" File ", gb);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);

  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotOpenFileDialog()));

  mLineEdit = new QMultiLineEdit(gb);
  vbox->addWidget(mLineEdit, 10);
  mLineEdit->setMinimumWidth(250);
  vbox->activate();

  vbox = new QVBoxLayout(0);
  horLayout->addLayout(vbox);

  vbox->addSpacing(gb->fontMetrics().height());

  btn = new QPushButton(" Apply ", this);
  QToolTip::add(btn, "Apply and Save");
  vbox->addWidget(btn, 0, AlignLeft);
  btn->setFixedSize(100, 25);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));

  btn = new QPushButton(" Save as", this);
  vbox->addWidget(btn, 0, AlignLeft);
  btn->setFixedSize(100, 25);
  QToolTip::add(btn, "Apply and Save As");

  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotSaveAs()));

  connect(alias,
	  SIGNAL(signUpdateData()),
	  this,
	  SLOT  (slotUpdateData()));

  vbox->addStretch(10);
  horLayout->activate();
  load();
  show();
}

AliasPage::~AliasPage()
{
#ifdef EDEBUG
  cout << "Destruktor AliasPage" << endl;
#endif
}

void AliasPage::load()
{
  QString item;
  QDict<char>* list = alias->getList();
  QDictIterator<char> it(*list);
  mLineEdit->setAutoUpdate(FALSE);
  mLineEdit->clear();
  for (;it.current();++it){
     QString s;
     s.sprintf("%s %s", it.currentKey(), it.current());
     mLineEdit->append(s);
  }
  mLineEdit->setAutoUpdate(TRUE);
  mLineEdit->repaint(FALSE);
}

void AliasPage::slotOpenFileDialog()
{
  QString p=lePath->text();
  if (p.isEmpty())
     p=aliasPath;
  QFileInfo fi(p);
  QString dir = fi.dirPath(TRUE);
  QString fileName = QFileDialog::getOpenFileName(dir, "*.alias");
  if (!fileName.isEmpty()){
     if (!alias->load(fileName))
        return;
     lePath->setText(fileName);
     load();
  }
}

void AliasPage::slotApply()
{
  QString p=lePath->text();
  if (p.isEmpty()){
     p=aliasPath;
     lePath->setText(aliasPath);
  }

  if (!p)
     return;
  QFile f(p);
  if (!f.open(IO_WriteOnly))
     return;
  aliasPath = p;
  QTextStream ts(&f);
  for (int i=0;i<mLineEdit->numLines();i++){
      QString s=mLineEdit->textLine(i);
      s=s.stripWhiteSpace();
      ts << s << endl;
  }
  f.close();
  alias->load(aliasPath);
}

void AliasPage::slotSaveAs()
{
  QString p=lePath->text();
  if (p.isEmpty())
     p=aliasPath;
  QFileInfo fi(p);
  QString dir = fi.dirPath(TRUE);
  QString fileName = QFileDialog::getSaveFileName(dir, "*.alias");
  if (!fileName.isEmpty()){
     lePath->setText(fileName);
     slotApply();
  }
}

void AliasPage::slotUpdateData()
{
  load();
}

