#ifndef __CLIENTCORE_H__
#define __CLIENTCORE_H__

#include "ircCore.h"

class ClientCore : public IrcCore
{
  Q_OBJECT
protected:
  QString mNick;
public:
  ClientCore(QObject* Parent=0, const char* Name=0, ulong CusInterval=60, bool Start=0);
  ~ClientCore();
  virtual QString cmdSubstitution(QDict<char>& list, const char* txt);
  virtual int     onMsg(const char*, const char*){return 1;}
signals:
  void signCommand  (const char* Name, const char* Cmd);
  void signWriteMsg (int Type, const char* Txt, bool Parsen=TRUE);
  void signDelClient(const char* Name);
public slots:
  void slotCurrentNick(const char*);
  void slotWriteMsg   (int Type, const char* Msg, bool Parsen=TRUE);
  
};

#endif
