#ifndef __COLOROPT_H__
#define __COLOROPT_H__

#include <qwidget.h>
#include <qgrpbox.h>
#include <kconfig.h>
#include <qlined.h>
#include <qpushbutton.h> 
#include <qlabel.h>
#include <qlist.h> 
#include <qdialog.h>
#include "fileListBox.h"

class ColorButton : public QPushButton
{
  Q_OBJECT
protected:
  QLabel* label;
protected:
  bool eventFilter ( QObject *, QEvent *e );
  virtual void resizeEvent    (QResizeEvent*);
public:
  ColorButton(const QColor&, const char* s=0L, QWidget* p=0L, const char* name=0L);
  ~ColorButton(){}
  virtual void setBackgroundColor(const QColor& col){
     label->setBackgroundColor(col);
  }  
};

class IrcColor : public QWidget
{
  Q_OBJECT
protected:
  static int     count;
public:
  static QColor  color[16];
  QList<ColorButton> btnList;
protected:
  void readConfig();
public:
  IrcColor(QWidget* parent=0L, const char* name=0L, 
	   WFlags f=WStyle_Customize | WStyle_NoBorder |WStyle_Tool);
  ~IrcColor(){}
signals:
  void signChanged(int id, const QColor&);
public slots:
  virtual void slotClicked(int);
};


class IrcColorDlg : public IrcColor
{
  Q_OBJECT
public:
  IrcColorDlg(QWidget* parent=0L, const char* name=0L, 
	      WFlags f=WStyle_Customize | WStyle_NoBorder |WStyle_Tool);
  ~IrcColorDlg(){}
public slots:
  virtual void slotClicked(int);
  void setBgColor();
};



class ColorOpt : public QWidget
{
  Q_OBJECT
public:
  ColorOpt( QWidget *parent = NULL, const char *name = NULL );
  ~ColorOpt();

signals:
  void    colorsChanged( const QColor &col, int Type);
  void    bgChanged    ( const char*);
protected slots:
  void    slotBgColorChanged   (const QColor &col );
  void    slotTextColorChanged (const QColor &col );
  void    slotMsgColorChanged  (const QColor &col );
  void    slotInfoColorChanged (const QColor &col );
  void    slotErrorColorChanged  (const QColor &col );
  void    slotActionColorChanged (const QColor &col );
  void    slotBgMDIColorChanged  (const QColor &col );
  void    slotApply();
  void    slotDelete();
private:
  void    readOptions();
  void    readConfig();
private:
  QColor bgColor;    // Background
  QColor textColor;  // my color
  QColor msgColor;   // Server msg Color
  QColor infoColor;  // link,vlink Color
  QColor actionColor;
  QColor errorColor;
  QColor bgMDIColor;
  QLineEdit* pathEdit;
  FileBox*   fileBox;
  QString pathbg;
};

#endif
