#include <sys/time.h>
#include <iostream.h>
#include "StringToken.h"
#include <qmsgbox.h> 
#include "kmsgbox.h"
#include "lineDialog.h"
#include "ircClient.h"
#include "IrcSocket.h"
#include "ircDialog.h"
#include "MsgParser.h"
#ifdef TCL
#include "tclCmd.h"
#endif
#include "ircDefine.h"
#include "ircBell.h"
#include "ircApp.h"
#include <qregexp.h> 

MsgCmdTab MsgParser::ctcpCmd[]={
    {"FINGER",    MsgParser::ctcpFinger  },
    {"CLIENTINFO",MsgParser::ctcpClientInfo },
    {"SOURCE",    MsgParser::ctcpSource },
    {"ACTION",    MsgParser::ctcpAction },
    {"DCC",       MsgParser::ctcpDCC    },
    {"SOUND",     MsgParser::ctcpSound  },
    {"MP3",       MsgParser::ctcpSound  },
    {NULL,             NULL}
};

MsgCmdTab MsgParser::dccCmd[]={
    {"CHAT",    MsgParser::dccChat  },
    {"SEND",    MsgParser::dccFile  },
    {NULL,             NULL}
};

int MsgParser::sendCtcpReply(const char* s)
{
  IrcCore* timer=client->timerList["CtcpReply"];
  if (!timer->isActive()){
     timer->start();
     client->getSocket().sendCtcpReply(s);
  }
  else
     client->ctcpReplyList.append(s);
  return 1;
}

// txt: to cmd 
int MsgParser::onCtcp(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onCtcp:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString cmd =tt.nextToken();
  QString rest=tt.toEnd();
  QString nick=ft.nextToken(" !");

  // Keine Action
  if (stricmp(cmd, "ACTION")){
     QString s="";
     s += 0x02;
     s += "="+nick+"=";
     s += 0x02;
     QString nm;
     if (!stricmp(to, client->currentNick()))
       nm = "You";
     else
       nm = to;
     s += " CTCP "+cmd+" request from "+0x02+nick+0x02+" ("+ft.toEnd()+") to "+nm;
     
     QString entry=ircapp->readEntry("OnEventOutputCTCP", "Status");
     if (!stricmp(entry, "Active"))
        client->slotWriteOnActive(TYPE_CTCP, s);
     else if (!stricmp(entry, "Status"))
        client->slotWriteMsg(TYPE_CTCP, s);
  }

  // hier muss zunaechst ausgefuehrt werden
  if (!stricmp(cmd, "VERSION"))
     ctcpVersion(from, to+" "+rest);
  else if (!stricmp(cmd, "PING"))
     ctcpPing   (from, to+" "+rest);

#ifdef TCL
  QString entry="BIND_CTCP";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
     QStrList funcName;
     funcName.setAutoDelete(TRUE);
     QString result;
     int nTcl=client->tclCmd->getBindProc("CTCP", cmd, funcName);

     if (nTcl){
       QString argv = nick+" "+to+" "+QString(from)+" "+cmd+" "+rest;
       client->tclCmd->evalCmd(funcName, argv, result);
       if (result=="1")
	 return 1;
     }
  }
#endif

  for (int i=0;ctcpCmd[i].name!=NULL;i++){
    if (!stricmp(cmd,ctcpCmd[i].name)){
       (this->*(ctcpCmd[i].func))(from, to+" "+rest);
       break;
    }
  }

  return 1; 
}

int MsgParser::ctcpFinger(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpFinger:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  = tt.nextToken();
  QString nick= ft.nextToken(" !"); 
  QString s=nick+" FINGER not yet implemented";
  IrcCore* timer=client->timerList["CtcpReply"];
  if (!timer->isActive()){
     timer->start();
     return client->getSocket().sendCtcpReply(s);
  }
  else
     client->ctcpReplyList.append(s);
  return 1;
}

int MsgParser::ctcpVersion(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpVersion:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to = tt.nextToken();
  QString nick=ft.nextToken(" !");
  QString s=nick+" VERSION Running kEirc version "+QString(KEIRC_VERSION)+" by Eko Bono";
  return sendCtcpReply(s);
}

int MsgParser::ctcpClientInfo(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpClientInfo:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to = tt.nextToken();
  QString nick=ft.nextToken(" !"); 
  QString s=nick+" CLIENTINFO kEirc IRC-Client on KDE";
  IrcCore* timer=client->timerList["CtcpReply"];
  if (!timer->isActive()){
     timer->start();
     return client->getSocket().sendCtcpReply(s);
  }
  else
     client->ctcpReplyList.append(s);
  return 1;
}

int MsgParser::ctcpPing(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpPing:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to = tt.nextToken();
  QString nick=ft.nextToken(" !"); 
  return client->getSocket().sendCtcpReply(nick+" PING "+tt.toEnd());
}

int MsgParser::ctcpSource(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpSource:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to = tt.nextToken();
  QString nick=ft.nextToken(" !"); 
  QString s=nick+" SOURCE This alpha version from kEirc";
  IrcCore* timer=client->timerList["CtcpReply"];
  if (!timer->isActive()){
     timer->start();
     return client->getSocket().sendCtcpReply(s);
  }
  else
     client->ctcpReplyList.append(s);
  return 1;
}

int MsgParser::ctcpDCC(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpDCC:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to  =tt.nextToken();
  QString cmd =tt.nextToken();
  QString rest=tt.toEnd();
  QString nick=ft.nextToken(" !");

#ifdef TCL
  QString entry="BIND_DCC";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);
    QString result;

    int nTcl=client->tclCmd->getBindProc("DCC", cmd, funcName);
    if (nTcl){
      QString argv = nick+" "+cmd+" "+QString(from)+" "+rest;
      client->tclCmd->evalCmd(funcName, argv, result);
      if (result=="1")
        return 1;
    }
  }
#endif

  for (int i=0;dccCmd[i].name!=NULL;i++){
    if (!stricmp(cmd,dccCmd[i].name)){
       (this->*(dccCmd[i].func))(from, rest);
       break;
    }
  }
  return 1;
}

int MsgParser::ctcpAction(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpAction:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString to=tt.nextToken();
  QString nick=ft.nextToken(" !");
  if (to[0]=='#' || to[0]=='&'){
     IrcChannel* ic=client->channel->find(to);
     if (!ic)
        return 0;
     QString s="ACTION "+tt.toEnd();
     return ic->onMsg(from, s);
  }
  IrcPrivMsg* ip=client->privMsg->find(nick);
  if (!ip){
     QString value=ircapp->readEntry("OnPrivMsg", "AutoAccept");
     if (value=="Ignore")
        return 0;
     else if (value=="AutoAccept")
        client->addPrivMsg(from);
     else {
        IrcDialog dlg (
		       client,
		       "PrivMsgDlgTimeout",
		       "PrivMsgDlgMax",
		       "PrivMsgDlgCur",
		       "Privmsg Dialog",
		       "Privmsg from "+nick+"("+QString(from)+")\n Accept it?\n",
		       "",
		       true,
		       0L,
		       from);
	if (dlg.exec())
	   client->addPrivMsg(from);
	else
	   return 0;
     }
     if (!(ip = client->privMsg->find(nick)))
        return 0;
  }
  QString s="ACTION "+tt.toEnd();
  return ip->onMsg(from, s);
}

int MsgParser::ctcpSound(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::ctcpSound:"<<from<<":"<<txt<<endl;
#endif

  // Check ignored
  if (client->isIgnored(from, "s"))
     return 1;

  StringToken ft(from);
  StringToken tt(txt);
  QString to = tt.nextToken();
  QString fi = tt.nextToken();
  QString nick=ft.nextToken(" !");

  QString entry, value;
  entry = "OnCTCPSound";
  value = ircapp->readEntry(entry, "AutoAccept");
  if (!stricmp(value, "Ignore"))
     return 0;
  else if (value=="Dialog"){
     IrcDialog dlg(
		   client,
		   "CTCPSoundDlgTimeout",
		   "CTCPSoundDlgMax",
		   "CTCPSoundDlgCur",
		   "CTCP Sound Dialog",
		   "CTCP Sound from "+nick+"\n("+QString(from)+")\n Accept it?\n",
		   "",
		   true,
		   0L,
		   from);
     if (!dlg.exec())
        return 0;
  }

  entry = "CTCPSoundDir";
  value = ircapp->readEntry(entry, ircapp->home);
  client->mediaDlg->slotPlayCTCP(value+"/"+fi);
  return 1;
}

int MsgParser::dccChat(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::dccChat:"<<from<<":"<<txt<<endl;
#endif

  // Check ignored
  if (client->isIgnored(from, "t"))
     return 1;

  StringToken ft(from);
  StringToken tt(txt);
  QString nick = ft.nextToken(" !");
  QString user = nick+"!"+ft.nextToken(" !");
  QString art  = tt.nextToken();
  
  IrcBell* ib=client->bell.find("DCCChatBell");
  if (ib)
     ib->slotPlay();
  DCCChat* dcc=client->dccChat->find(user);
  if (!dcc){
     QString value=ircapp->readEntry("OnDCCChat", "Dialog");
     if (value=="Ignore")
        return 0;
     else if (value=="AutoAccept")
        client->addDCCChat(user, tt.toEnd());
     else {
        IrcDialog dlg(
		      client,
		      "DCCChatDlgTimeout",
		      "DCCChatDlgMax",
		      "DCCChatDlgCur",
		      "DCC Chat Dialog",
		      "DCC Chat from "+nick+"\n("+QString(from)+")\n Accept it?\n",
		      "",
		      true,
		      0L,
		      from);
	if (dlg.exec())
	   client->addDCCChat(user, tt.toEnd());
	else
	   return 0;
     }
  }
  return 0;
}

// DCC FILE filename ip port size
int MsgParser::dccFile(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::dccFile:"<<from<<":"<<txt<<endl;
#endif

  // Check ignored
  if (client->isIgnored(from, "f"))
     return 1;

  StringToken ft(from);
  StringToken tt(txt);
  QString nick = ft.nextToken(" !");
  QString user = nick+"!"+ft.nextToken(" !");
  
  IrcBell* ib=client->bell.find("DCCFileBell");
  if (ib)
     ib->slotPlay();

  QString value=ircapp->readEntry("OnDCCFile", "Dialog");
  if (value=="Ignore")
     return 0;
  else if (value=="AutoAccept")
     client->addDCCFile(user, tt.toEnd());
  else {
     IrcDialog dlg(
		   client,
		   "DCCFileDlgTimeout",
		   "DCCFileDlgMax",
		   "DCCFileDlgCur",
		   "DCC File Dialog",
		   "DCC File from "+nick+"\n("+QString(from)+")\n Accept it?\n",
		   "",
		   true,
		   0L,
		   from);
     if (dlg.exec())
        client->addDCCFile(user, tt.toEnd());
     else
        return 0;
  }
  return 0;
}



int MsgParser::onCtcpReply(const char* from, const char* txt)
{
#ifdef EDEBUG
  cout << "MsgParser::onCtcpReply:"<<from<<":"<<txt<<endl;
#endif
  StringToken ft(from);
  StringToken tt(txt);
  QString cmd=tt.nextToken();
  QString nick= ft.nextToken(" !"); 
  QString s="";
  int Type;
  if (!(stricmp(cmd, "PING"))){
     QString ts=tt.nextToken();
     ulong delta = (ulong)time(NULL)-ts.toULong();
     ts.setNum(delta);
     s +=  "CTCP PING reply from :"+ nick+" "+ts+" seconds";
     Type = TYPE_INFO|TYPE_IMG;
  }
  else{
     s += 0x02;
     s += "="+nick+"=";
     s += 0x02;
     s += " "+QString(txt);
     Type = TYPE_CTCP;
  }
  client->slotWriteOnActive(Type, s);

#ifdef TCL
  QString entry="BIND_CTCR";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes"){
    QStrList funcName;
    funcName.setAutoDelete(TRUE);
    int nTcl=client->tclCmd->getBindProc("CTCR", cmd, funcName);
    
    if (nTcl){
      QString argv = nick+" "+client->curNick+" "+QString(from)+" "+cmd+" "+tt.toEnd();
      client->tclCmd->evalCmd(funcName, argv);
    }
  }
#endif


  return 1;
}





