#include <qgrpbox.h>
#include <iostream.h>
#include "StringToken.h"
#include "lineDialog.h"
#include <qlayout.h>

LineDialog::LineDialog(QWidget *parent, const char *name, bool modal, const char* topic)
     :QDialog( parent, name, modal)
{
#ifdef EDEBUG
  cout << "Konstruktor LineDialog..."<<endl;
#endif
    mTitle = topic;

    eWidget.setAutoDelete(false);
    lWidget.setAutoDelete(false);
    resize(300, 200);
}

LineDialog::~LineDialog()
{
#ifdef EDEBUG
  cout << "Destruktor LineDialog..." << endl;
#endif
}

void LineDialog::setText(QString label, QString edit, QString delim)
{
#ifdef EDEBUG
  cout << "LineDialog::setText(QString, QString)..."<<endl;
#endif
  StringToken lst(label, delim);
  StringToken est(edit,  delim);
  QStrList ll, le;
  ll.setAutoDelete(true);
  le.setAutoDelete(true);
  while(lst.hasMoreTokens())
    ll.append(lst.nextToken());
  while(est.hasMoreTokens())
    le.append(est.nextToken());
  setText(ll, le);
#ifdef EDEBUG
  cout << "LineDialog::setText(QString, QString)...Ok"<<endl;
#endif
}

void LineDialog::setText(QStrList& label, QStrList& edit)
{
#ifdef EDEBUG
  cout << "LineDialog::setText(QStrList, QStrList)..."<<endl;
#endif
  QVBoxLayout* topLayout = new QVBoxLayout(this, 10);
  QGroupBox*   gb = new QGroupBox(this);
  topLayout->addWidget(gb);
  QVBoxLayout* verLayout = new QVBoxLayout(gb, 10);
  eWidget.clear();
  lWidget.clear();
  QString l, e;
  l=label.first();
  e=edit.first();
  QHBoxLayout* hbox=NULL;
  QLabel*      wLabel;
  IrcLine*     wEdit;
  for (;l=label.current();l=label.next()){
     hbox = new QHBoxLayout(5);
     verLayout->addLayout(hbox);

     lWidget.append(wLabel = new QLabel (l, gb));
     hbox->addWidget(wLabel, 2);
     wLabel->setFixedHeight(25);
     eWidget.append(wEdit  = new IrcLine(gb));
     hbox->addWidget(wEdit, 5);
     wEdit->setFixedHeight(25);
     if (e=edit.current()){
        wEdit->setText(e);
        e=edit.next();
     }
     connect(wEdit, SIGNAL(returnPressed()),
	     this,  SLOT  (accept()));
  }
  verLayout->addSpacing(5);

  verLayout->addLayout(hbox);

  hbox->addStretch(10);
  QPushButton* btn;
  btn = new QPushButton( "Ok", gb);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);
  connect( btn, SIGNAL(clicked()), this, SLOT(accept()));

  btn = new QPushButton( "Cancel", gb);
  hbox->addWidget(btn);
  btn->setFixedSize(100, 25);
  hbox->addStretch(10);

  connect( btn, SIGNAL(clicked()), this, SLOT(reject()));

  eWidget.at(0)->setFocus();
  if (!mTitle.isNull())
     setCaption(mTitle);

  topLayout->addStretch(10);
  verLayout->activate();
  topLayout->activate();
  resize(300, (label.count()+2)*30);
#ifdef EDEBUG
  cout << "LineDialog::setText(QStrList, QStrList)...Ok"<<endl;
#endif
}

QString LineDialog::getText(int idx, bool strip)
{
   QString e = eWidget.at(idx)->text();
   if (!e.isNull() && !e.isEmpty()){
      if (strip==true)
	 e=e.stripWhiteSpace();
      return e;
   }
   return QString("");
}

#include "lineDialog.moc"

