#ifndef __ONEVENTPAGE_H__
#define __ONEVENTPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qlayout.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h>

class IrcClient;

class OnEventOutputPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QVBoxLayout* verLayout;
  QHBoxLayout* horLayout;

  QDict<QButtonGroup> btnGroup;
  QDict<QRadioButton> radioBtn;
  QStrList            valueText;
  QStrList            eventText;
  QStrList            dlgEvent;
public:
  OnEventOutputPage(IrcClient* Client, QWidget *parent = 0L, const char *name = 0L );
  ~OnEventOutputPage();
protected:
  void    Init();
  void    readConfig();
  void    createValueRadioBtn();
  void    createEventRadioBtn();
protected slots:
  void slotCurrentPage(const char* page){
      if (!stricmp(page, name()))
	 readConfig();
  } 
  void slotValueClicked(int);
  void slotEventClicked(int);
};

#endif
