#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "onInvitePage.h"
#include "onInvitePage.moc"
#include "ircBell.h"
#include "ircApp.h"

void OnInvitePage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);

  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnInvitePage::OnInvitePage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createPushButton();

  IrcBell* ib;
  QString  es="InviteBell";
  client->bell.insert(es, ib=new IrcBell(client, es, this));
  grid->addWidget(ib, 1, 1);

  topLayout->activate();
  readConfig();
  show();
}

OnInvitePage::~OnInvitePage()
{
#ifdef EDEBUG
  cout << "Destruktor OnInvitePage" << endl;
#endif
}


void OnInvitePage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoJoin"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Join", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  //bg->setFixedHeight(4*bg->fontMetrics().height());
  vbox->activate();
}

void OnInvitePage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());
  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  QLabel* label;
  KIntegerLine* il;

  label = new QLabel("Max Accepted Invite", gb);
  hbox->addWidget(label,5);
  configText.append(entry="InvDlgMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Dialog Timeout [second]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="InvDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(il->sizeHint().height());
  hbox->addWidget(il,1); 

  vbox->addStretch(10);
  gb->setFixedHeight(4*gb->fontMetrics().height());
  vbox->activate();
}



void OnInvitePage::createPushButton()
{
  QPushButton* btn;
  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  grid->addWidget(btn, 1, 0, AlignLeft|AlignTop);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnInvitePage::readConfig()
{
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;rbtn=it.current();++it)
     rbtn->setChecked(false);
  entry = "OnChannelInvite";
  value = ircapp->readEntry(entry, "Dialog");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);
  
  // max window
  entry = "InvDlgMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "InvDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);
}

void OnInvitePage::slotApply()
{
#ifdef EDEBUG
  cout << "OnInvitePage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnChannelInvite";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  // maxCount
  entry = "InvDlgMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "InvDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  client->bell["InviteBell"]->slotApply();
}








