#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qregexp.h>
#include "kprocess.h"
#include "kmsgbox.h"
#include "StringToken.h"
#include "ircDefine.h"
#include "ircClient.h"
#include "fileListBox.h"
#include "onTclPage.h"
#include "ircEdit.h"
#include "ircApp.h"

OnTclPage::OnTclPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget(parent, name)
{
#ifdef EDEBUG
  cout << "OnTclPage Konstruktor"<<endl;
#endif
  this->client=client;

  horLayout  = new QHBoxLayout(this, 10);
  lVerLayout = new QVBoxLayout(5);
  horLayout->addLayout(lVerLayout,5);

  createListBox();
  lVerLayout->addSpacing(30);

  rVerLayout = new QVBoxLayout(0);
  horLayout->addLayout(rVerLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  show();
}

OnTclPage::~OnTclPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnTclPage" << endl;
#endif
}


void OnTclPage::createListBox()
{
#ifdef EDEBUG
  cout << "OnTclPage::createListBox" << endl;
#endif

  QFrame* frame = new QFrame(this);
  frame->setLineWidth(2);
  frame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

  lVerLayout->addWidget(frame, 10);

  QVBoxLayout* vbox = new QVBoxLayout(frame, 3);

  listBox   = new KTabListBox(frame, "listBox", 2);
  vbox->addWidget(listBox, 10);
  listBox->setMinimumSize(320,250);
  listBox->setColumn(0, "Filename");
  listBox->setColumn(1, "Loaded");
  listBox->setColumnWidth(0, 150);
  listBox->setColumnWidth(1, 75);
  listBox->setSeparator  (':');
  vbox->activate();

  QHBoxLayout* hbox = new QHBoxLayout;
  lVerLayout->addLayout(hbox);
  QLabel*  label = new QLabel("Tcl DIR :" , this);

  hbox->addWidget(label, 10);
  label->setFixedHeight(25);

  dirBox = new FileDirBox(this);
  hbox->addWidget(dirBox, 10);
  dirBox->setFixedHeight(25);

  hbox = new QHBoxLayout;
  lVerLayout->addLayout(hbox);

  label = new QLabel("Editor :" , this);
  hbox->addWidget(label, 10);
  label->setFixedHeight(25);

  editBox = new QLineEdit(this);
  hbox->addWidget(editBox, 10);
  editBox->setFixedHeight(25);
}

void OnTclPage::createButton()
{
#ifdef EDEBUG
  cout << "OnTclPage::createBotton" << endl;
#endif
  QPushButton* btn;

  btn = new QPushButton(" Load new", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotLoadNew()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Edit new", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEditNew()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Load it", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotLoadIt()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Edit it", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotEditIt()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelete()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addSpacing(10);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  rVerLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  rVerLayout->addStretch(10);
}

void OnTclPage::readConfig()
{
  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  QStrList list;
  list.setAutoDelete(true);

  int n=config->readListEntry("TclScript", list, listBox->separator());
  if (n>0){
     listBox->appendStrList(&list);
      for (uint i=0;i<listBox->count();i++){
         QString f = listBox->text(i, 0);
	 if (client->tclCmd->evalFile(f)<1)
	    listBox->changeItem(f+listBox->separator()+"-", i);
      }
  }

  dir = ircapp->readEntry("TclScriptDir", ircapp->home);
  dirBox->setPath(dir);
  QString editor=ircapp->readEntry("TclScriptEditor", "kedit file:%");
  editBox->setText(editor);
}

// -1 : nicht vorhanden
//  0 : vorhanden nicht geladen
//  1 : vorhanden und geladen
int OnTclPage::checkItem(QString f, int* idx)
{
  for (uint i=0;i<listBox->count();i++){
     QString t=listBox->text(i, 0);
     QString c=listBox->text(i, 1);
     if (!stricmp(f, t) && !stricmp(c,"+")){
       *idx = i;
       KMsgBox::message(this, "Load Dialog", "File "+t+ " is already loaded", 
			KMsgBox::INFORMATION, "OK");
       return 1;
     }
     else if (!stricmp(f, t)){
       *idx = i;
       return 0;
     }
  }
  return -1;
}


void OnTclPage::slotLoadNew()
{
  QString fileName = QFileDialog::getOpenFileName(dirBox->getPath(), "*.tcl");
  if (!fileName.isEmpty()){
     int idx;
     int status=checkItem(fileName, &idx);
     //if (status==1)
     // return;
     QString c="+";
     int eval=client->tclCmd->evalFile(fileName);
     if (eval<1)
	 c="-";
     // not loaded
     if (status==-1)
        listBox->appendItem(fileName+listBox->separator()+c);
     else
	listBox->changeItem(fileName+listBox->separator()+c, idx);
     
     if (eval==1)
        listBox->setCurrentItem(-1);
  }
}

void OnTclPage::slotLoadIt()
{
  int idx = listBox->currentItem();
  if (idx<0)
     return;
  QString f=listBox->text(idx, 0);
  QString c=listBox->text(idx, 1);
  //if (!stricmp(c,"+"))
  // return;

  int eval=client->tclCmd->evalFile(f);
  if (eval<1)
     c="-";
  listBox->changeItem(f+listBox->separator()+c, idx);
}

void OnTclPage::edit(const char* file)
{
  QString editor=editBox->text();
  if (editor.isEmpty())
     editor="kedit file:%";
  QRegExp re("%");
  int idx = editor.find(re);
  if (idx>=0)
     editor.replace(re, file);
  else
     editor += " "+QString(file);

  StringToken st(editor);
  QString p=st.nextToken();
  QString a=st.toEnd();

  KProcess proc;
  proc << p << a;
  proc.start(KProcess::DontCare);
}

void OnTclPage::slotEditNew()
{
#ifdef EDEBUG
  cout << "OnTclPage::slotEditNew"<<endl;
#endif
  QString fileName = QFileDialog::getOpenFileName(dirBox->getPath(), "*.tcl");
  if (!fileName.isEmpty())
     edit(fileName);
}

void OnTclPage::slotEditIt()
{
#ifdef EDEBUG
  cout << "OnTclPage::slotEditIt"<<endl;
#endif
  int idx = listBox->currentItem();
  if (idx<0)
     return;
  QString t=listBox->text(idx, 0);
  edit(t);
}

void OnTclPage::slotDelete()
{
  int idx = listBox->currentItem();
  if (idx>=0)
     listBox->removeItem(idx);
  
}

void OnTclPage::slotApply()
{
  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  QStrList list;
  list.setAutoDelete(true);
  QString s;
  for (uint i=0;i<listBox->count();i++){
     QString f = listBox->text(i, 0);
     QString p = listBox->text(i, 1);
     s = f+listBox->separator()+p;
     list.append(s);
  }
  config->writeEntry("TclScript", list, listBox->separator());

  dir = dirBox->getPath();
  ircapp->writeEntry("TclScriptDir",    dir);
  ircapp->writeEntry("TclScriptEditor", editBox->text());
}

void OnTclPage::loadTcl(const char* file)
{
  if (file==0L || strlen(file)<1)
     return;

  QString fileName;
  if (file[0]=='/')
     fileName=file;
  else{
     QString dir = dirBox->getPath();
     fileName = dir+"/"+QString(file);
  }

  int idx;
  int status=checkItem(fileName, &idx);
  QString c="+";
  int eval=client->tclCmd->evalFile(fileName);
  if (eval<1)
     c="-";
  // not loaded
  if (status==-1)
     listBox->appendItem(fileName+listBox->separator()+c);
  else
     listBox->changeItem(fileName+listBox->separator()+c, idx);
     
  if (eval==1)
     listBox->setCurrentItem(-1);
}


#include "onTclPage.moc"


