#!/usr/bin/env python
##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

VERSION='0.4'
import getopt, sys
from update import Update
from localtoremotetransfer import LocalToRemoteTransfer
from remotetolocaltransfer import RemoteToLocalTransfer

def usage():
    print
    print 'ftpupdater '+VERSION
    print
    print """Usage ftpupdater [-c config_file] [-i] [-f] [-d] project_name
    
    -c config_file specifies the optional configuration file
                   ~/update.config is the default.
    
    -i             indicates that the file time stamps
                   database should be constructed for this project
                   and no files transferred.
    
    -f             indicates that all files should be transferred
                   regardless of time stamps.

    -d             dry run; it shows what would happen for project_name but
                   no files are transferred or deleted.
                   
    -x             interactively confirm deletions on target

    """
    sys.exit(1)

def quit(detail=None):
    print "Illegal arguments."
    if detail!=None: print detail
    usage()
try:
    optlist,args=getopt.getopt(sys.argv[1:],'c:ifdhx')
except getopt.error,detail:
    quit(detail)
if len(args)!=1:
    quit("You must specify one project.")
config=None
initdb=0
force=0
dryrun=0
confirmdel=0
for opt in optlist:
    if opt[0]=='-h': quit("")
    if opt[0]=='-c': config=opt[1]
    if opt[0]=='-d': dryrun=1
    if opt[0]=='-i': initdb=1
    if opt[0]=='-f': force=1
    if opt[0]=='-x': confirmdel=1
if (force and (initdb or dryrun)) or (dryrun and initdb):
    quit("Incompatible options")
update=Update(args[0],config) #name, config file
if update.readconfig():
    if update.put and initdb:
        update.init_transfer(noftplogin=1)
    else:
        if not update.initftp():
            print update.error
            sys.exit(1)
        update.init_transfer()
    if initdb:
        update.empty_db()
        print "Creating time stamps database"
        if not update.init_db():
            print update.error
            if not update.put: update.ftpQuit()
            sys.exit(1)
        if not update.put: update.ftpQuit()
        sys.exit(0)
    elif force:
        if not update.cleardb():
            print update.error
            sys.exit(1)
        update.setConfirmDel(confirmdel)
        sys.exit(update.init())
    elif dryrun:
        if not update.readdb():
            print update.error
            print "\nYou need to create a time stamps database.\n"
            usage()
        else:
            update.setDry(1)
            sys.exit(update.init())
    else:
        if not update.readdb():
            print update.error
            print "\nYou need to create a time stamps database.\n"
            usage()
        else:
            update.setConfirmDel(confirmdel)
            sys.exit(update.init())

else:
    sys.exit(1)
    