##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

import os
from stat import *
from ftp import *
from abstracttransfer import AbstractTransfer
from transferhelpers import *
#blocksize for ftp put operation
BLK=8192
class LocalToRemoteTransfer(AbstractTransfer):
    """
    Methods to transfer files etc from a local directory
    to a remote directory
    """
    def __init__(self,ldir,rdir,ftp,dbfile):
        AbstractTransfer.__init__(self,ldir,rdir,ftp,dbfile)
    def smdtm(self,f):
        return os.stat(f)[ST_MTIME]
    def put(self,f):
        try:
            fd=open(f,'r')
        except IOError,detail:
            self.error=("Could not open "+f+" to write",detail[1])
            return 0
        else:
            try:
                self.init_progress(f)
                self.ftp.setProgress(self.do_progress,self.finish_progress)
                self.ftp.storbinary3('STOR '+self.path_sTot(f),fd,BLK)
            except all_errors,detail:
                self.error=("Could not put file "+f,detail)
                fd.close()
                return 0
        fd.close()
        return 1

    def size(self,f):
        return os.stat(f)[ST_SIZE]

    def sfilesdirs(self,d):
        return local_filesdirs(d)

    def tfilesdirs(self,d):
        try:
            files,dirs=self.ftp.filesdirs(d)
        except all_errors,detail:
            self.error=("Couldn't get list of files and directories in "+d,detail)
            return None,None
        return files,dirs
    def tdelete(self,f):
        try:
            self.ftp.delete(f)
        except all_errors,detail:
            self.error=("Couldn't delete remote file "+f,detail)
            return 0
        else:
#            if f in self.db.keys(): del self.db[f]
            return 1
    def tmkd(self,d):
        try:
            self.ftp.mkd(d)
        except all_errors,detail:
            self.error=("Couldn't create remote directory "+d,detail)
            return 0
        return 1
    def temptydir(self,d):
        try:
            self.ftp.emptydir(d)
        except all_errors,detail:
            self.error=("Couldn't empty directory "+d,detail)
            return 0
        else:
#            for k in self.db.keys():
#                if k[:len(d)]==d:
#                    del self.db[k]
            return 1
