##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

from mainwindow import MainWindow
from kdecore import KApplication
import sys, getopt


def usage():
    print "Usage:"
    print sys.argv[0]+" [ -c config_file ] [ -i ] [ -f ] [ project_name ]"
    print """
    
    -c config_file specifies the optional configuration file
                   ~/update.config is the default.
    
    -i             indicates that the file time stamps
                   database should be constructed for project_name
                   and no files transferred.
    
    -f             indicates that all files should be transferred
                   regardless of time stamps for project_name

    -d             dry run; it shows what would happen for project_name but
                   no files are transferred or deleted.

    project_name   transfer files for this project
    """
def main():
    #deal with command line arguments
    config=None
    initdb=0
    force=0
    dry=0
    project=None
    try:
        optlist,args=getopt.getopt(sys.argv[1:],'c:ifd')
    except getopt.error:
        usage()
    else:
        if len(args)==1:
            project=args[0]
            for opt in optlist:
                if opt[0]=='-c': config=opt[1]
                if opt[0]=='-i': initdb=1
                if opt[0]=='-f': force=1
                if opt[0]=='-d': dry=1
            if (force and (initdb or dry)) or (dry and initdb):
                force=initdb=dry=0
                project=None
                print "Incompatible options"
                usage()

    app=KApplication(sys.argv,"kftpupdater")
    toplevel=MainWindow(config,initdb,force,dry,project)
    app.setMainWidget(toplevel)
    toplevel.show()
    app.exec_loop()

if __name__=="__main__":
    main()
    