##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

from qt import *
from kdecore import i18n
from kfile import KFileDialog

class MainTab(QWidget):
#class for Main Tab on project edit/create dialog
    def __init__(self,parent,name,proj_name,new,p):
            QWidget.__init__(self,parent,name)

            self.name=proj_name
            self.parent=parent

            comp_label =QLabel(i18n("These settings must be filled in"),self)
            comp_label.setMinimumSize(comp_label.sizeHint())

            host_label= QLabel( i18n("Remote hostname:") , self)
            host_label.setMinimumSize( host_label.sizeHint() )

            self.host = QLineEdit( self,'')
            if not new:
                self.host.setText(p.get(self.name,'host'))
            self.host.setMinimumSize( self.host.sizeHint())
            self.host.setFocus()  #focus on the host box

            login_label= QLabel( i18n("Username:") , self)
            login_label.setMinimumSize( login_label.sizeHint() )

            self.login = QLineEdit( self,'')
            if not new:
                self.login.setText(p.get(self.name,'login'))

            self.login.setMinimumSize( self.login.sizeHint())

            passwd_label= QLabel( i18n("Password:") , self)
            passwd_label.setMinimumSize( passwd_label.sizeHint() )

            self.passwd = QLineEdit( self,'')
            self.passwd.setEchoMode( QLineEdit.EchoMode.Password )
            if not new:
                self.passwd.setText(p.get(self.name,'passwd'))
            self.passwd.setMinimumSize( self.passwd.sizeHint())

            ldir_label= QLabel( i18n("Local directory:") , self)
            ldir_label.setMinimumSize( ldir_label.sizeHint() )

            self.ldir = QLineEdit( self,'')
            if not new:
                self.ldir.setText(p.get(self.name,'ldir'))
            self.ldir.setMinimumSize( self.ldir.sizeHint())

            self.ldirbut=QPushButton("Browse",self,'')
            self.ldirbut.setMinimumSize(self.ldirbut.sizeHint())
            self.connect(self.ldirbut,SIGNAL("clicked()"),self.browse)

            Sep = QFrame(self)
            Sep.setFrameStyle( QFrame.HLine | QFrame.Sunken )
            Sep.setLineWidth( 2 )
            Sep.setFixedHeight( 2 )

            opt_label =QLabel(i18n("Leave this blank if the remote directory is the current directory after logging in"),self)
            opt_label.setMinimumSize(opt_label.sizeHint())

            rdir_label= QLabel( i18n("Remote directory:") , self)
            rdir_label.setMinimumSize( rdir_label.sizeHint() )

            self.rdir = QLineEdit( self,'')
            if not new and 'rdir' in p.options(self.name):
                self.rdir.setText(p.get(self.name,'rdir'))
            self.rdir.setMinimumSize( self.rdir.sizeHint())

            self.put=QCheckBox(i18n("Check to put files, uncheck to get files"),self,'')
            self.put.setMinimumSize(self.put.sizeHint())
            if not new:
                self.put.setChecked(p.getboolean(self.name,'put'))
            else:
                self.put.setChecked(1)

            self.kill=QCheckBox(i18n("Check to delete files and directories in the target directory not in the source directory"),self,'')
            self.kill.setMinimumSize(self.kill.sizeHint())
            if not new and 'kill' in p.options(self.name):
                self.kill.setChecked(p.getboolean(self.name,'kill'))
            else:
                self.kill.setChecked(0)

                        
            widget = QVBoxLayout( self, 10 )

            comp_layout = QHBoxLayout()
            host_layout = QHBoxLayout()
            login_layout = QHBoxLayout()
            passwd_layout = QHBoxLayout()
            ldir_layout = QHBoxLayout()
            rdir_layout = QHBoxLayout()
            put_layout = QHBoxLayout()
            kill_layout = QHBoxLayout()
            ok_layout = QHBoxLayout()
            opt_layout = QHBoxLayout()

            widget.addLayout( comp_layout)
            widget.addStretch(1)

            widget.addLayout( host_layout )
            widget.addStretch(1)

            widget.addLayout( login_layout )
            widget.addStretch(1)

            widget.addLayout( passwd_layout )
            widget.addStretch(1)

            widget.addLayout( ldir_layout )
            widget.addStretch(1)

            widget.addLayout( put_layout )
            widget.addStretch(1)

            widget.addLayout( kill_layout )
            widget.addStretch(1)

            widget.addWidget(Sep)
            widget.addStretch(1)

            widget.addLayout( opt_layout)
            widget.addStretch(1)

            widget.addLayout( rdir_layout )
            widget.addStretch(1)

            comp_layout.addStretch(1)
            comp_layout.addWidget(comp_label)
            comp_layout.addStretch(1)

            host_layout.addWidget( host_label )
            host_layout.addStretch(1)
            host_layout.addWidget( self.host, 1 )

            login_layout.addWidget( login_label )
            login_layout.addStretch(1)
            login_layout.addWidget( self.login, 1 )

            passwd_layout.addWidget( passwd_label )
            passwd_layout.addStretch(1)
            passwd_layout.addWidget( self.passwd, 1 )

            ldir_layout.addWidget( ldir_label )
            ldir_layout.addStretch(1)
            ldir_layout.addWidget( self.ldir, 1 )
            ldir_layout.addStretch(1)
            ldir_layout.addWidget( self.ldirbut, 1 )

            rdir_layout.addWidget( rdir_label )
            rdir_layout.addStretch(1)
            rdir_layout.addWidget( self.rdir, 1 )

            put_layout.addWidget( self.put)

            kill_layout.addWidget( self.kill,1)

            opt_layout.addStretch(1)
            opt_layout.addWidget(opt_label)
            opt_layout.addStretch(1)

            self.show()

    def browse(self):
        self.ldir.setText(str(KFileDialog.getSaveFileName()))

class RegExp(QWidget):
#class for Ignore Tab on project edit/create dialog
    def __init__(self,parent,name,proj_name,new,p):
            QWidget.__init__(self,parent,name)

            self.name=proj_name
            self.parent=parent

            opt_label =QLabel(i18n("Restrict files and directories in source directory considered for update. Leave blank to consider all files"),self)
            opt_label.setMinimumSize(opt_label.sizeHint())

            ignore_label= QLabel( i18n("Ignore files matching reg exp:") , self)
            ignore_label.setMinimumSize( ignore_label.sizeHint() )

            self.ignore = QLineEdit( self,'')
            if not new and 'ignore' in p.options(self.name):
                self.ignore.setText(p.get(self.name,'ignore'))

            self.ignore.setMinimumSize( self.ignore.sizeHint())
            self.ignore.setFocus()

            only_label= QLabel( i18n("Ignore files not matching reg exp:") , self)
            only_label.setMinimumSize( only_label.sizeHint() )

            self.only = QLineEdit( self,'')
            if not new and 'only' in p.options(self.name):
                self.only.setText(p.get(self.name,'only'))

            self.only.setMinimumSize( self.only.sizeHint())

            ignoredirs_label= QLabel( i18n("Ignore directories matching reg exp:") , self)
            ignoredirs_label.setMinimumSize( ignoredirs_label.sizeHint() )

            self.ignoredirs = QLineEdit( self,'')
            if not new and 'ignoredirs' in p.options(self.name):
                self.ignoredirs.setText(p.get(self.name,'ignoredirs'))

            self.ignoredirs.setMinimumSize( self.ignoredirs.sizeHint())

            onlydirs_label= QLabel( i18n("Ignore directories not matching reg exp:") , self)
            onlydirs_label.setMinimumSize( onlydirs_label.sizeHint() )

            self.onlydirs = QLineEdit( self,'')
            if not new and 'onlydirs' in p.options(self.name):
                self.onlydirs.setText(p.get(self.name,'onlydirs'))

            self.onlydirs.setMinimumSize( self.onlydirs.sizeHint())

            Sep = QFrame(self)
            Sep.setFrameStyle( QFrame.HLine | QFrame.Sunken )
            Sep.setLineWidth( 2 )
            Sep.setFixedHeight( 2 )

            self.kill=QCheckBox(i18n("Check to delete ignored files and directories in target directory"),self,'')
            self.kill.setMinimumSize(self.kill.sizeHint())
            if not new and 'ignorekill' in p.options(self.name):
                self.kill.setChecked(p.getboolean(self.name,'ignorekill'))
            else:
                self.kill.setChecked(0)

            widget = QVBoxLayout( self, 10 )

            ignore_layout = QHBoxLayout()
            only_layout = QHBoxLayout()
            ignoredirs_layout = QHBoxLayout()
            onlydirs_layout = QHBoxLayout()
            opt_layout= QHBoxLayout()
            kill_layout=QHBoxLayout()

            widget.addLayout( opt_layout)
            widget.addStretch(1)

            widget.addLayout( ignore_layout )
            widget.addStretch(1)

            widget.addLayout( only_layout )
            widget.addStretch(1)

            widget.addLayout( ignoredirs_layout )
            widget.addStretch(1)

            widget.addLayout( onlydirs_layout )
            widget.addStretch(1)

            widget.addWidget(Sep)
            widget.addStretch(1)

            widget.addLayout(kill_layout)

            opt_layout.addStretch(1)
            opt_layout.addWidget(opt_label)
            opt_layout.addStretch(1)


            ignore_layout.addWidget( ignore_label )
            ignore_layout.addStretch(1)
            ignore_layout.addWidget( self.ignore, 1 )

            only_layout.addWidget( only_label )
            only_layout.addStretch(1)
            only_layout.addWidget( self.only, 1 )

            ignoredirs_layout.addWidget( ignoredirs_label )
            ignoredirs_layout.addStretch(1)
            ignoredirs_layout.addWidget( self.ignoredirs, 1 )

            onlydirs_layout.addWidget( onlydirs_label )
            onlydirs_layout.addStretch(1)
            onlydirs_layout.addWidget( self.onlydirs, 1 )

            kill_layout.addWidget(self.kill)

            self.show()

class Misc(QWidget):
#class for Misc Tab on project edit/create dialog
    def __init__(self,parent,name,proj_name,new,p):
            QWidget.__init__(self,parent,name)

            self.name=proj_name
            self.parent=parent

            opt_label =QLabel(i18n("Alternative log and database files. Leave blank for the defaults"),self)
            opt_label.setMinimumSize(opt_label.sizeHint())

            gateway_label =QLabel(i18n("If you require a second login once on the server:"),self)
            gateway_label.setMinimumSize(gateway_label.sizeHint())

            Sep = QFrame(self)
            Sep.setFrameStyle( QFrame.HLine | QFrame.Sunken )
            Sep.setLineWidth( 2 )
            Sep.setFixedHeight( 2 )

            db_label= QLabel( i18n("Time stamps database:") , self)
            db_label.setMinimumSize( db_label.sizeHint() )

            self.db = QLineEdit( self,'')
            if not new and 'db' in p.options(self.name):
                self.db.setText(p.get(self.name,'db'))
            
            self.db.setMinimumSize( self.db.sizeHint())

            self.dbbut=QPushButton("Browse",self,'')
            self.dbbut.setMinimumSize(self.dbbut.sizeHint())
            self.connect(self.dbbut,SIGNAL("clicked()"),self.dbbrowse)

            log_label= QLabel( i18n("Log file:") , self)
            log_label.setMinimumSize( log_label.sizeHint() )

            self.log = QLineEdit( self,'')
            if not new and 'log' in p.options(self.name):
                self.log.setText(p.get(self.name,'log'))
            
            self.log.setMinimumSize( self.log.sizeHint())
            self.log.setFocus()
            self.logbut=QPushButton("Browse",self,'')
            self.logbut.setMinimumSize(self.logbut.sizeHint())
            self.connect(self.logbut,SIGNAL("clicked()"),self.logbrowse)

            login1_label= QLabel( i18n("Second Username:") , self)
            login1_label.setMinimumSize( login1_label.sizeHint() )

            self.login1 = QLineEdit( self,'')
            if not new and 'login1' in p.options(self.name):
                self.login1.setText(p.get(self.name,'login1'))

            self.login1.setMinimumSize( self.login1.sizeHint())

            passwd1_label= QLabel( i18n("Second Password:") , self)
            passwd1_label.setMinimumSize( passwd1_label.sizeHint() )

            self.passwd1 = QLineEdit( self,'')
            if not new and 'passwd1' in p.options(self.name):
                self.passwd1.setText(p.get(self.name,'passwd1'))

            self.passwd1.setEchoMode( QLineEdit.EchoMode.Password )
            self.passwd1.setMinimumSize( self.passwd1.sizeHint())

                        
            widget = QVBoxLayout( self, 10 )

            opt_layout= QHBoxLayout()

            log_layout = QHBoxLayout()
            db_layout = QHBoxLayout()
            gateway_layout = QHBoxLayout()
            login1_layout = QHBoxLayout()
            passwd1_layout = QHBoxLayout()

            widget.addLayout( opt_layout)
            widget.addStretch(1)

            widget.addLayout( log_layout )
            widget.addStretch(1)

            widget.addLayout( db_layout )
            widget.addStretch(1)

            widget.addWidget(Sep)
            widget.addStretch(1)

            widget.addLayout( gateway_layout)
            widget.addStretch(1)

            widget.addLayout( login1_layout )
            widget.addStretch(1)

            widget.addLayout( passwd1_layout )
            widget.addStretch(1)

            opt_layout.addStretch(1)
            opt_layout.addWidget(opt_label)
            opt_layout.addStretch(1)


            log_layout.addWidget( log_label )
            log_layout.addStretch(1)
            log_layout.addWidget( self.log, 1 )
            log_layout.addStretch(1)
            log_layout.addWidget( self.logbut, 1 )

            db_layout.addWidget( db_label )
            db_layout.addStretch(1)
            db_layout.addWidget( self.db, 1 )
            db_layout.addStretch(1)
            db_layout.addWidget( self.dbbut, 1 )

            gateway_layout.addStretch(1)
            gateway_layout.addWidget(gateway_label)
            gateway_layout.addStretch(1)

            login1_layout.addWidget( login1_label )
            login1_layout.addStretch(1)
            login1_layout.addWidget( self.login1, 1 )

            passwd1_layout.addWidget( passwd1_label )
            passwd1_layout.addStretch(1)
            passwd1_layout.addWidget( self.passwd1, 1 )
            self.show()

    def dbbrowse(self):
        self.db.setText(str(KFileDialog.getSaveFileName()))

    def logbrowse(self):
        self.log.setText(str(KFileDialog.getSaveFileName()))
