/* $Id: kget.h,v 1.3 1999/02/23 21:50:39 koss Exp $
   $Log: kget.h,v $
   Revision 1.3  1999/02/23 21:50:39  koss
   Replaced about dialog and help menu with getHelpMenu() from
   KApplication
   getSize() is now called only for queued transfers ( not for delayed )
   statusbar update for speed and remaining time

   Revision 1.2  1999/02/19 15:43:56  koss
   Fixed bug in showing speed, it remained from the times of kget 0.5.1
   when only ppp speed was showed.
   Fixed transfer mode switching + updateToolbar() + checkQueue()

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.3  1999/02/07 17:27:53  matt
   updated for new setting dialogs
   new item statuses
   get sizes function
   slotError() update
   updated for new icons

   Revision 1.2  1998/12/19 19:40:34  matt
   new philosophy - mode and status
   new toolbar items
   new popup
   renaming items

   Revision 1.1.1.1  1998/05/06 19:13:31  matt
   Imported sources

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */


#ifndef _KGET_H_
#define _KGET_H_

#include <drag.h>
#include <qtimer.h>
#include <qdatetime.h>

#include <kmenubar.h>
#include <ktopwidget.h>

#include "kmytablistbox.h"

class KIOJob;
class KAudio;
class KMainWidget;
class ConfigDlg;

class KItem : public QObject {
    
public:
  enum { MD_QUEUED, MD_DELAYED, MD_SCHEDULED  };

  enum { ST_STOPPED, ST_RUNNING, ST_TRYING, ST_FINISHED,
	 ST_RETRYING, ST_SIZE_CHECK };

  KItem( const char *_src, const char *_dest, int _id, KIOJob *_job, int _mode )
    {
      src = _src; dest = _dest;
      id = _id; job = _job;
      mode = _mode;

      totalSize = 0;  processedSize = 0; percent = 0;
      totalFiles = 1; processedFiles = 0;
      status = ST_STOPPED;
      canResume = true;
      startTime = QDateTime::currentDateTime();
      speed = 0;
    }
  
  friend class KMainWidget;
  friend class ConfigDlg;

protected:

  QString src;
  QString dest;
  
  int id;
  KIOJob *job;

  QDateTime startTime;

  unsigned long totalSize;
  unsigned long processedSize;
  int percent;
  int totalFiles;
  int processedFiles;

  int speed;
  QTime remainingTime;

  int status;
  int mode;

  int retryCount;

  bool canResume;
};


class KMainWidget : public KTopLevelWidget {

    Q_OBJECT

public:
  KMainWidget( const char *name=0 );
  ~KMainWidget();
  
  enum { TOOL_RESUME, TOOL_PAUSE, TOOL_DELETE, TOOL_PAUSE_ALL,
	 TOOL_QUEUE, TOOL_TIMER, TOOL_DELAY,
	 TOOL_PREFERENCES, TOOL_PASTE,
	 TOOL_EXPERT, TOOL_DISCONNECT, TOOL_SHUTDOWN, 
	 TOOL_DOCK
  };
  
  enum { STATUS_EMPTY, STATUS_DELAYED, STATUS_LOADING, STATUS_SCHEDULED };

  friend class ConfigDlg;

protected:

  void closeEvent( QCloseEvent * );

  void readSettings();
  void writeSettings();

  void readTransfers( bool ask_for_name = false );
  void writeTransfers( bool ask_for_name = false );

  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupTabListBox();

  void updateToolBar();
  void updateStatusBar();

  void addTransfer(QString s);

  void checkQueue();

  void Connect( KIOJob *job );

  // utility function
  void disconnect();
  int downloadStatus();
  bool checkOnline();
  QString convertSize( int size );

  KToolBar::BarPosition toolbarPos;
  KMenuBar::menuPosition menubarPos;
  bool showStatusbar;

  bool b_deleteMode;

  // connection options
  bool b_reconnectOnError;
  uint reconnectTime;
  uint reconnectRetries;
  bool b_reconnectOnBroken;

  uint timeoutData;
  uint timeoutDataNoResume;
//   uint timeoutSearch;

  // automation options
  bool b_autoSave;
  uint autoSaveInterval;
  bool b_autoDisconnect;
  QString disconnectCommand;
  bool b_autoShutdown;

  //  bool b_netscapeIntegrate;

  // limits options
  uint maxSimultaneousConnections;
  uint minimumBandwidth;
  uint maximumBandwidth;

  // advanced options
  bool b_addQueued;
  bool b_showDownloadWindows;
  bool b_startIconified;
  bool b_removeOnSuccess;
  bool b_getSizes;
  //  bool b_useCookies;
  bool b_expertMode;

  // system options
  bool b_dockWindow;

  bool b_useSound;

  QString audioFinished;
  QString audioFinishedAll;
  QString audioStartScheduled;

  bool b_useAnimation;

  /**
   * The image from 0...animatedLogo.count() - 1 we are currently
   * displaying.
     * 
     * @see #animatedLogo
     */
  uint animCounter;
  /**
     * Times used to display the animated logo.
     *
     * @see #animatedLogo
     */
  QTimer *animTimer;
  QTimer *transferTimer;
  QTimer *autosaveTimer;
  
  ConfigDlg *confdlg;

private:    

  KMenuBar *myMenuBar;
  KToolBar *myToolBar;
  KStatusBar *myStatusBar;
  KMyTabListBox *myTabListBox;

  QPopupMenu *file, *options, *help, *popup;

  KAudio *audio;

  QFont  tablistboxfont;

  QString properties;

  QList<KItem> GlobalItemList;

  // Popup menu IDs
  int pop_resume, pop_pause, pop_delay;
  int pop_queued, pop_scheduled, pop_delayed;
  int pop_begin, pop_end;

  // Options menu IDs
  int op_statusbar, op_useanimation, op_usesound;

public slots:

  void quit();

  void openTransfer();
  void pasteTransfer();
  void exportTransfers();
  void importTransfers();

  void resumeCurrent();
  void pauseCurrent();
  void deleteCurrent();
  void pauseAll();

  void queueCurrent();
  void timerCurrent();
  void delayCurrent();

  void configCurrent();
  void openDownloadWindow();

  void toggleDocking();
  void toggleExpertMode();
  void toggleAutoDisconnect();
  void toggleAutoShutdown();

  void slotAnimTimeout();
  void slotTransferTimeout();
  void slotAutosaveTimeout();

  void slotShowStatusbar();
  void slotAnimateStatus();
  void slotSoundStatus();
  void slotPreferences();

  void slotSpeed( int, unsigned long );
  void slotProcessedSize( int, unsigned long );
  void slotTotalSize( int, unsigned long );
  void slotTotalFiles( int, unsigned long );
  void slotProcessedFiles( int, unsigned long );

  void slotFinished( int );
  void slotCanceled( int );
  void slotError( int, int, const char* );
  void slotCopying( int, const char*, const char* );
  void slotRenamed( int, const char* );
  void slotCanResume( int, bool );

  /// Drag and Drop
  void slotDropEvent( KDNDDropZone * _dropZone );

  /// Click on TabListBox
  void slotHighlightedEvent( int Index );
  void slotMidClickEvent( int Index );

  void slotPopupMenu( int Index );
  void slotMoveToBegin();
  void slotMoveToEnd();
  void slotCopyToClipboard();

};

extern KMainWidget *p_kmain;

#endif
