/***************************************************************************
                          kgutenbookData.cpp  -  description
                             -------------------
    begin                : Thu Dec 2 1999
    copyright            : (C) 1999 & 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 #include "kgutenbook.h"
 #include <kapp.h>
 #include <qpixmap.h>
 #include <kiconloader.h>
 #include <qdir.h>
 #include <qprinter.h>
 #include <qtooltip.h>
 #include <stdio.h>


 void Kgutenbook::initKDialog()
 {

	qtarch_DownloadButton = new QPushButton( this, "DownloadButton" );
	qtarch_DownloadButton->setMinimumSize( 0, 0 );
	qtarch_DownloadButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_DownloadButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_DownloadButton->setFontPropagation( QWidget::NoChildren );
	qtarch_DownloadButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_DownloadButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/down.xpm") );
//  	qtarch_DownloadButton->setText( (i18n("&Download")) );
	qtarch_DownloadButton->setAutoRepeat( FALSE );
	qtarch_DownloadButton->setAutoResize( FALSE );
	qtarch_DownloadButton->setToggleButton( FALSE );
	qtarch_DownloadButton->setDefault( FALSE );
	qtarch_DownloadButton->setAutoDefault( FALSE );
	qtarch_DownloadButton->setIsMenuButton( FALSE );
	  	
	qtarch_LibraryButton = new QPushButton( this, "LibraryButton" );
	qtarch_LibraryButton->setMinimumSize( 0,0 );
	qtarch_LibraryButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_LibraryButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_LibraryButton->setFontPropagation( QWidget::NoChildren );
	qtarch_LibraryButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_LibraryButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/home.xpm") );
	//  setText((i18n( "&Library")) );
	qtarch_LibraryButton->setAutoRepeat( FALSE );
	qtarch_LibraryButton->setAutoResize( FALSE );
	qtarch_LibraryButton->setToggleButton( FALSE );
	qtarch_LibraryButton->setDefault( FALSE );
	qtarch_LibraryButton->setAutoDefault( FALSE );
	qtarch_LibraryButton->setIsMenuButton( FALSE );

	qtarch_OpenButton = new QPushButton( this, "OpenButton" );
	qtarch_OpenButton->setMinimumSize( 0,0 );
	qtarch_OpenButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_OpenButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_OpenButton->setFontPropagation( QWidget::NoChildren );
	qtarch_OpenButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_OpenButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/openbook.xpm") );
	//setText( (i18n("&Open")) );
	qtarch_OpenButton->setAutoRepeat( FALSE );
	qtarch_OpenButton->setAutoResize( FALSE );
	qtarch_OpenButton->setToggleButton( FALSE );
	qtarch_OpenButton->setDefault( FALSE );
	qtarch_OpenButton->setAutoDefault( FALSE );
	qtarch_OpenButton->setIsMenuButton( FALSE );
	
	qtarch_ForwardButton = new QPushButton( this, "ForwardButton" );
	qtarch_ForwardButton->setMinimumSize( 0, 0 );
	qtarch_ForwardButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_ForwardButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_ForwardButton->setFontPropagation( QWidget::NoChildren );
	qtarch_ForwardButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_ForwardButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/forward.xpm") );
	//  setText((i18n( "&Forward")) );
	qtarch_ForwardButton->setAutoRepeat( FALSE );
	qtarch_ForwardButton->setAutoResize( FALSE );
	qtarch_ForwardButton->setToggleButton( FALSE );
	qtarch_ForwardButton->setDefault( FALSE );
	qtarch_ForwardButton->setAutoDefault( FALSE );
	qtarch_ForwardButton->setIsMenuButton( FALSE );

	qtarch_BackButton = new QPushButton( this, "BackButton" );
	qtarch_BackButton->setMinimumSize(0, 0 );
	qtarch_BackButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_BackButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_BackButton->setFontPropagation( QWidget::NoChildren );
	qtarch_BackButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_BackButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/back.xpm") );
	//  setText( (i18n("&Back")) );
	qtarch_BackButton->setAutoRepeat( FALSE );
	qtarch_BackButton->setAutoResize( FALSE );
	qtarch_BackButton->setToggleButton( FALSE );
	qtarch_BackButton->setDefault( FALSE );
	qtarch_BackButton->setAutoDefault( FALSE );
	qtarch_BackButton->setIsMenuButton( FALSE );

	qtarch_PrintButton = new QPushButton( this, "PrintButton" );
	qtarch_PrintButton->setMinimumSize( 0, 0 );
	qtarch_PrintButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_PrintButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_PrintButton->setFontPropagation( QWidget::NoChildren );
	qtarch_PrintButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_PrintButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/fileprint.xpm") );
	//  setText((i18n( "&Print")) );
	qtarch_PrintButton->setAutoRepeat( FALSE );
	qtarch_PrintButton->setAutoResize( FALSE );
	qtarch_PrintButton->setToggleButton( FALSE );
	qtarch_PrintButton->setDefault( FALSE );
	qtarch_PrintButton->setAutoDefault( FALSE );
	qtarch_PrintButton->setIsMenuButton( FALSE );

	qtarch_SearchButton = new QPushButton( this, "SearchButton" );
	qtarch_SearchButton->setMinimumSize( 0, 0 );
	qtarch_SearchButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_SearchButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_SearchButton->setFontPropagation( QWidget::NoChildren );
	qtarch_SearchButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_SearchButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/search.xpm") );
	//  setText( (i18n("&Search")) );
	qtarch_SearchButton->setAutoRepeat( FALSE );
	qtarch_SearchButton->setAutoResize( FALSE );
	qtarch_SearchButton->setToggleButton( FALSE );
	qtarch_SearchButton->setDefault( FALSE );
	qtarch_SearchButton->setAutoDefault( FALSE );
	qtarch_SearchButton->setIsMenuButton( FALSE );
		
	qtarch_ExitButton = new QPushButton( this, "ExitButton" );
	qtarch_ExitButton->setMinimumSize(0, 0 );
	qtarch_ExitButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_ExitButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_ExitButton->setFontPropagation( QWidget::NoChildren );
	qtarch_ExitButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_ExitButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/exit.xpm") );
	//  setText( (i18n("&Exit")) );
	qtarch_ExitButton->setAutoRepeat( FALSE );
	qtarch_ExitButton->setAutoResize( FALSE );
	qtarch_ExitButton->setToggleButton( FALSE );
	qtarch_ExitButton->setDefault( FALSE );
	qtarch_ExitButton->setAutoDefault( FALSE );
	qtarch_ExitButton->setIsMenuButton( FALSE );
	
	lastBmkButton = new QPushButton( this, "lastBmkButton" );
	lastBmkButton->setMinimumSize( 0, 0 );
	lastBmkButton->setFocusPolicy( QWidget::TabFocus );
	lastBmkButton->setBackgroundMode( QWidget::PaletteBackground );
	lastBmkButton->setFontPropagation( QWidget::NoChildren );
	lastBmkButton->setPalettePropagation( QWidget::NoChildren );
	lastBmkButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/flag.xpm") );
	//  setText( (i18n("goto Book&Mark")) );
	lastBmkButton->setAutoRepeat( FALSE );
	lastBmkButton->setAutoResize( FALSE );
	lastBmkButton->setToggleButton( FALSE );
	lastBmkButton->setDefault( FALSE );
	lastBmkButton->setAutoDefault( FALSE );
	lastBmkButton->setIsMenuButton( FALSE );
	
	setBookmarkButton = new QPushButton( this, "setBookmark" );
	setBookmarkButton->setMinimumSize( 0, 0 );
	setBookmarkButton->setMaximumSize( 32767, 32767 );
	setBookmarkButton->setFocusPolicy( QWidget::TabFocus );
	setBookmarkButton->setBackgroundMode( QWidget::PaletteBackground );
	setBookmarkButton->setFontPropagation( QWidget::NoChildren );
	setBookmarkButton->setPalettePropagation( QWidget::NoChildren );
	setBookmarkButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/tick.xpm") );
	//  setText( (i18n("setMa&rk")) );
	setBookmarkButton->setAutoRepeat( FALSE );
	setBookmarkButton->setAutoResize( FALSE );
	setBookmarkButton->setToggleButton( FALSE );
	setBookmarkButton->setDefault( FALSE );
	setBookmarkButton->setAutoDefault( FALSE );
	setBookmarkButton->setIsMenuButton( FALSE );
	
	FontButton = new QPushButton( this, "FontButton" );
	FontButton->setMinimumSize( 0, 0 );
	FontButton->setMaximumSize( 32767, 32767 );
	FontButton->setFocusPolicy( QWidget::TabFocus );
	FontButton->setBackgroundMode( QWidget::PaletteBackground );
	FontButton->setFontPropagation( QWidget::NoChildren );
	FontButton->setPalettePropagation( QWidget::NoChildren );
	FontButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/text.xpm") );
	//  setText( (i18n("Fon&t")) );
	FontButton->setAutoRepeat( FALSE );
	FontButton->setAutoResize( FALSE );
	FontButton->setToggleButton( FALSE );
	FontButton->setDefault( FALSE );
	FontButton->setAutoDefault( FALSE );
	FontButton->setIsMenuButton( FALSE );

 	ClearButton = new QPushButton( this, "ClearButton" );
	ClearButton->setMinimumSize( 0, 0 );
	ClearButton->setMaximumSize( 32767, 32767 );
	ClearButton->setFocusPolicy( QWidget::TabFocus );
	ClearButton->setBackgroundMode( QWidget::PaletteBackground );
	ClearButton->setFontPropagation( QWidget::NoChildren );
	ClearButton->setPalettePropagation( QWidget::NoChildren );
	ClearButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/eraser.xpm") );
	//  setText( (i18n("Cle&ar")) );
	ClearButton->setAutoRepeat( FALSE );
	ClearButton->setAutoResize( FALSE );
	ClearButton->setToggleButton( FALSE );
	ClearButton->setDefault( FALSE );
	ClearButton->setAutoDefault( FALSE );
	ClearButton->setIsMenuButton( FALSE );

	qtarch_HelpButton = new QPushButton( this, "AboutButton" );
	qtarch_HelpButton->setMinimumSize( 0, 0 );
	qtarch_HelpButton->setMaximumSize( 32767, 32767 );
	qtarch_HelpButton->setFocusPolicy( QWidget::TabFocus );
	qtarch_HelpButton->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_HelpButton->setFontPropagation( QWidget::NoChildren );
	qtarch_HelpButton->setPalettePropagation( QWidget::NoChildren );
	qtarch_HelpButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/help.xpm") );
	//  setText( (i18n("&About")) );
	qtarch_HelpButton->setAutoRepeat( FALSE );
	qtarch_HelpButton->setAutoResize( FALSE );
	qtarch_HelpButton->setToggleButton( FALSE );
	qtarch_HelpButton->setDefault( FALSE );
	qtarch_HelpButton->setAutoDefault( FALSE );
	qtarch_HelpButton->setIsMenuButton( FALSE );
	
 	dictionaryButton = new QPushButton( this, "dictionaryButton" );
	dictionaryButton->setMinimumSize( 0, 0 );
	dictionaryButton->setMaximumSize( 32767, 32767 );
	dictionaryButton->setFocusPolicy( QWidget::TabFocus );
	dictionaryButton->setBackgroundMode( QWidget::PaletteBackground );
	dictionaryButton->setFontPropagation( QWidget::NoChildren );
	dictionaryButton->setPalettePropagation( QWidget::NoChildren );
	dictionaryButton->setPixmap( QPixmap(kapp->kde_toolbardir() +"/spellcheck.xpm") );
	//  setText( (i18n("Loo&kup")) );
	dictionaryButton->setAutoRepeat( FALSE );
	dictionaryButton->setAutoResize( FALSE );
	dictionaryButton->setToggleButton( FALSE );
	dictionaryButton->setDefault( FALSE );
	dictionaryButton->setAutoDefault( FALSE );
	dictionaryButton->setIsMenuButton( FALSE );

//////////////////////////////////////////////////////////////////////////  MultiLineEdit	
	
	m_Left_Text = new MultiLine_Ex(this, "Left_Text" );
	m_Left_Text->setMinimumSize( 0, 0 );
	m_Left_Text->setMaximumSize( 32767, 32767 );
	m_Left_Text->setFocusPolicy( QWidget::StrongFocus );
	m_Left_Text->setBackgroundMode( QWidget::PaletteBase );
	m_Left_Text->setFontPropagation( QWidget::SameFont );
	m_Left_Text->setPalettePropagation( QWidget::SameFont );
	m_Left_Text->setFrameStyle( 49 );
	m_Left_Text->setLineWidth( 2 );
	m_Left_Text->setMidLineWidth( 0 );
	m_Left_Text->QFrame::setMargin( 0 );
	m_Left_Text->setReadOnly( TRUE);
	m_Left_Text->setOverwriteMode( FALSE );
	m_Left_Text->setAutoUpdate( TRUE );
	
	m_Right_Text = new MultiLine_Ex( this, "Right_Text" );
	m_Right_Text->setMinimumSize( 0, 0 );
	m_Right_Text->setMaximumSize( 32767, 32767 );
	m_Right_Text->setFocusPolicy( QWidget::StrongFocus );
	m_Right_Text->setBackgroundMode( QWidget::PaletteBase );
	m_Right_Text->setFontPropagation( QWidget::SameFont );
	m_Right_Text->setPalettePropagation( QWidget::SameFont );
	m_Right_Text->setFrameStyle( 49 );
	m_Right_Text->setLineWidth( 2 );
	m_Right_Text->setMidLineWidth( 0 );
	m_Right_Text->QFrame::setMargin( 0 );
	m_Right_Text->setReadOnly( TRUE );
	m_Right_Text->setOverwriteMode( FALSE );
	m_Right_Text->setAutoUpdate( TRUE );
///////////////////////////////////////////////////////////////////////  End MultiLineEdit	
	
	StatusBar = new QLabel( this, "Status_Bar" );
	StatusBar->setMinimumSize( 0, 0 );
	StatusBar->setFocusPolicy( QWidget::NoFocus );
	StatusBar->setBackgroundMode( QWidget::PaletteBackground );
	StatusBar->setFontPropagation( QWidget::NoChildren );
	StatusBar->setPalettePropagation( QWidget::NoChildren );
	StatusBar->setFrameStyle( 0 );
	StatusBar->setLineWidth( 2 );
	StatusBar->setMidLineWidth( 0 );
	StatusBar->QFrame::setMargin( 0 );
	StatusBar->setText( status="KgutenBook" );
	StatusBar->setAlignment( 289 );
	StatusBar->setMargin( -1 );
	
  printer = new QPrinter;
  printer->setMinMax( 1, 10 );

  qtarch_DownloadButton->setMinimumSize(60, 22 );
  qtarch_LibraryButton->setMinimumSize( 60, 22 );
  qtarch_OpenButton->setMinimumSize( 60, 22 );
  qtarch_PrintButton->setMinimumSize( 60, 22 );
  qtarch_SearchButton->setMinimumSize( 60, 22 );
  qtarch_ForwardButton->setMinimumSize( 60, 22);
  qtarch_BackButton->setMinimumSize( 60, 22 );
  lastBmkButton->setMinimumSize( 60, 22 );
  setBookmarkButton->setMinimumSize( 60, 22 );
  FontButton->setMinimumSize(  60, 22 );
  ClearButton->setMinimumSize( 60, 22 );
  qtarch_ExitButton->setMinimumSize( 60, 22 );
  qtarch_HelpButton->setMinimumSize(  60, 22);

  qtarch_DownloadButton->setMaximumSize(60, 22 );
  qtarch_LibraryButton->setMaximumSize( 60, 22 );
  qtarch_OpenButton->setMaximumSize( 60, 22 );
  qtarch_PrintButton->setMaximumSize( 60, 22 );
  qtarch_SearchButton->setMaximumSize( 60, 22 );
  qtarch_ForwardButton->setMaximumSize( 60, 22);
  qtarch_BackButton->setMaximumSize( 60, 22 );
  lastBmkButton->setMaximumSize( 60, 22 );
  setBookmarkButton->setMaximumSize( 60, 22 );
  FontButton->setMaximumSize(  60, 22 );
  ClearButton->setMaximumSize( 60, 22 );
  qtarch_ExitButton->setMaximumSize( 60, 22 );
  qtarch_HelpButton->setMaximumSize(  60, 22);

  dictionaryButton->setMinimumSize(  60, 22);

	QBoxLayout *topLayout = new QVBoxLayout( this, 10 );
	QBoxLayout *buttons = new QHBoxLayout();
	topLayout->addLayout( buttons, 0);
	QBoxLayout *buttons2 = new QHBoxLayout();
	topLayout->addLayout( buttons2, 0);

InfoBar = new QLabel( this, "Info_Bar" );
 	buttons->addWidget(qtarch_DownloadButton, 10, AlignTop  );
 	buttons->addWidget(qtarch_LibraryButton, 10, AlignTop );
 	buttons->addWidget(qtarch_PrintButton, 10, AlignTop);
 	buttons->addWidget(qtarch_SearchButton, 10, AlignTop );
  buttons->addWidget(ClearButton, 10, AlignTop);	
 	buttons->addStretch( 3);
 	buttons->addWidget( InfoBar, 10, AlignTop );
 	buttons->addWidget(qtarch_ExitButton, 10, AlignRight );

 	buttons2->addWidget(qtarch_OpenButton, 10, AlignTop );
  buttons2->addWidget(qtarch_BackButton, 10, AlignTop );
 	buttons2->addWidget(qtarch_ForwardButton, 10, AlignTop  );
 	buttons2->addWidget(setBookmarkButton, 10, AlignTop );
 	buttons2->addWidget(lastBmkButton, 10, AlignTop );
 	buttons2->addWidget(FontButton, 10, AlignTop );
 	buttons2->addWidget( dictionaryButton, 10, AlignTop );
	buttons2->addStretch(10);
	buttons2->addWidget(qtarch_HelpButton, 10, AlignRight );

  QBoxLayout *edits = new QHBoxLayout();
  QGridLayout *grid = new QGridLayout( 1, 20, 0 );
  topLayout->addLayout( edits,10 );
  edits->addLayout( grid, 10 );
	
	grid->addMultiCellWidget( m_Left_Text, 0, 0, 0, 18, 0);
	grid->addMultiCellWidget( m_Right_Text, 0, 0, 19, 19, 0);
  QBoxLayout *statusBar = new QHBoxLayout();
  QGridLayout *grid2 = new QGridLayout( 1, 20, 0 );

  topLayout->addLayout( statusBar,1 );
  statusBar->addLayout( grid2, 0 );

	connect( qtarch_DownloadButton, SIGNAL(released()), SLOT(DownloadIndex()) );
	connect( qtarch_LibraryButton, SIGNAL(released()), SLOT(LibraryBtn()) );
	connect( qtarch_OpenButton, SIGNAL(released()), SLOT(OpenBtn()) );
 	connect( qtarch_ForwardButton, SIGNAL(clicked()), SLOT(ForwardBtn()) );
	connect( qtarch_BackButton, SIGNAL(clicked()), SLOT(BackBtn()) );
	connect( qtarch_PrintButton, SIGNAL(released()), SLOT(PrintBtn()) );
	connect( qtarch_SearchButton, SIGNAL(released()), SLOT(SearchBtn()) );
	connect( qtarch_ExitButton, SIGNAL(released()), SLOT( ByeBye()) );
	connect( lastBmkButton, SIGNAL(released()), SLOT(Bookmark()) );
	connect( setBookmarkButton, SIGNAL(released()), SLOT(setBookmark()) );
	connect( FontButton, SIGNAL(clicked()), SLOT(ChangeFont()) );
	connect( ClearButton, SIGNAL(clicked()), SLOT( ClearEdit()) );
	connect( qtarch_HelpButton, SIGNAL(released()), SLOT(HelpBtn()) );
	connect( dictionaryButton, SIGNAL(released()), SLOT(LookupBtn()) );

  QToolTip::add( qtarch_DownloadButton, (i18n("Download the Library Index, and ftp site list" )));
  QToolTip::add( qtarch_LibraryButton, (i18n("Select a book to download" )));
  QToolTip::add( qtarch_OpenButton, (i18n("Open a book from the local library" )));
  QToolTip::add( qtarch_ForwardButton, (i18n("Page forward" )));
  QToolTip::add( qtarch_BackButton, (i18n("Page backward")) );
  QToolTip::add( qtarch_PrintButton, (i18n("Prints *not tested*")) );
  QToolTip::add( qtarch_SearchButton, (i18n("Searches etext for a word" )));
  QToolTip::add( qtarch_ExitButton, (i18n("Go bye-bye")) );
  QToolTip::add( lastBmkButton, (i18n("Opens last set bookmark" )));
  QToolTip::add( setBookmarkButton, (i18n("Sets bookmark to current etext and page")) );
  QToolTip::add( FontButton, (i18n("Change the current font" )));
  QToolTip::add( ClearButton, (i18n("Clears the text" )));
	QToolTip::add( qtarch_HelpButton, (i18n("About info" )));
  QToolTip::add( dictionaryButton, (i18n("For wwwebster dictionary lookup, just highlight word, and click this" )));

	QWidget *d = QApplication::desktop();
  int width=d->width();
 if(width < 1000)
 {
////////////////////////////////// if small vid resolution
	StatusBar->setMaximumSize(  380, 22 );
  dictionaryButton->setMaximumSize( 60, 22);
  grid2->addMultiCellWidget( StatusBar, 0, 0, 0, 18, 0);
  topLayout->	activate();
	
 int w, h;
 QString str;

 config = kapp->getConfig();	
 config->setGroup( "Geometry" );
 str = config->readEntry("Frame", "760,580");

 if(  !str.isEmpty() && str.find(',')>=0) {
    sscanf(str,"%d,%d",&w,&h);
    resize(w,h);
  } else {
  resize( 760,580 );
  }
 } else {
//////////////////////////////// large resolution gets different layout
  StatusBar->setMaximumSize(  450, 22 );	
  dictionaryButton->setMaximumSize( 60, 22);

  grid2->addMultiCellWidget( StatusBar, 0, 0, 0, 19, 0);
  topLayout->	activate();

 int w, h;
 QString str;
 config = kapp->getConfig();	
 config->setGroup( "Geometry" );
 str = config->readEntry("Frame", "990,640");
 if(  !str.isEmpty() && str.find(',')>=0) {
		 sscanf(str,"%d,%d",&w,&h);
		 resize(w,h);
 } else {
		 resize( 990,640 );
 }
 }
 setMinimumSize( 0, 0 );
 setMaximumSize( 32767, 32767 );


 }


//	  {                //            foreground               background             border (light))             dark                     mid                          text                 background  (base)
//		QColorGroup normal( QColor( QRgb(65280) ), QColor( QRgb(8421376) ), QColor( QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(8388736) ), QColor( QRgb(16777215) ), QColor( QRgb(8421376) ) );
//		QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ), QColor( QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(8421504) ), QColor( QRgb(8421376) ) );
//		QColorGroup active( QColor( QRgb(255) ), QColor( QRgb(8388608) ), QColor( QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(8388736) ), QColor( QRgb(16777215) ), QColor( QRgb(8421376) ) );
//		QPalette palette( normal, disabled, active );
//		m_Left_Text->setPalette( palette );
//	}	
//	{              //            foreground               background             border (light))             dark                     mid                          text                 background  (base)
//		QColorGroup normal( QColor(  QRgb(255)  ), QColor( QRgb(8388608) ), QColor( QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(8388736) ), QColor( QRgb(16777215) ), QColor( QRgb(8421376) ) );
//		QColorGroup disabled( QColor( QRgb(255) ), QColor( QRgb(8388608) ), QColor(QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(10789024) ), QColor( QRgb(8421504) ), QColor( QRgb(8421376) ) );
//		QColorGroup active( QColor( QRgb(255) ), QColor( QRgb(8388608) ), QColor(QRgb(12632256) ), QColor( QRgb(8421504) ), QColor( QRgb(8388736) ), QColor( QRgb(16777215) ), QColor( QRgb(8421376) ) );
//		QPalette palette( normal, disabled, active );
//		m_Right_Text->setPalette( palette );
//	}

//this doesnt seem to wrok with the new libs...
