/***************************************************************************
                          ftpsitedlg.cpp  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999 & 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "ftpsitedlg.h"
#include "kgutenbook.h"
#include <kfm.h>
#include <kprocess.h>

ftpSiteDlg::ftpSiteDlg(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();

	ListFile = ( QDir::homeDirPath ()) +"/.kgutenbook/ftpList";

	QFileInfo ftpList( ListFile);
	if ( ftpList.exists() )
	{
			switch( QMessageBox::information( 0, (i18n("Download new FTP site list?")),
																				(i18n("Do you want to download the newest\n"
																							"Project Gutenberg ftp site list?\n")),
																				(i18n("&Download")), (i18n("&Open")), 0 ) )
			{
					case 0: // download clicked,
					{
							getSite();
					}
					break;
					case 1: // select open
							openSiteList();
							break;
			};
	}
	else
	{
			getSite();
	}

}

ftpSiteDlg::~ftpSiteDlg()
{
}

void ftpSiteDlg::select_site( const char *index )
{
//   ftp://ftp.datacanyon.com/pub/gutenberg/
		s_site = index;
		int i_ftp = s_site.find("/", 7, FALSE);
		host = s_site.left(i_ftp );
		host.remove(0, 6);
		base_dir = s_site.right( s_site.length() - i_ftp);

		if( base_dir.right(1) != "/")
		{
				base_dir = base_dir + "/";
		}
//  QMessageBox::message( "Note", base_dir  );

		KConfig *config = kapp->getConfig();	
		config = kapp->getConfig();	
		config->setGroup( "FTPsite" );
		config->writeEntry("SiteName",host);
		config->writeEntry("base",base_dir);
		config->sync();	

		ftpSiteDlg::accept();
}

void ftpSiteDlg::getSite()
{
		QString file_name;
		QString ftp_listFileURL;
		QString ftpList;
    QFile f2( ListFile);
    if( f2.exists() )
    f2.remove();
		KConfig *config = kapp->getConfig();	
		config->setGroup( "Browser" );
		QString  brow = config->readEntry("Preferred", "KFM");

		file_name =  QDir::homeDirPath () + "/thisfileFTP.txt";

		if(brow =="KFM")
		{
				KFM::download("http://www.promo.net/pg/list.html", file_name);
		}
		else
		{
		KProgress *progress;
		progress = new  KProgress( this, "Progress");
		
				QString cmd = "lynx -source http://www.promo.net/pg/list.html | cat >> " +file_name;
				system(cmd);	
				delete progress;
		}
		QString msg;
		msg = "chmod 660 " +file_name;
		system(msg);

// QMessageBox::message( "file_name", file_name  );
		QFile f( file_name);
		if(!f.open( IO_ReadWrite ))
		{
				QMessageBox::message( (i18n("Note")), (i18n("File not opened sucessfully." )) );
		}
		else
		{
				QTextStream t( &f);
				while ( !t.eof() )
				{
						QString s = t.readLine();
						int start;
						int end;
	
						if(( start = s.find( "ftp://", 0, TRUE))!=-1 )
						{
								end = s.find( "target=", 0, TRUE);// ==-1)) {
								if( end == -1)
								{
										end = s.find( "\">");
								}
								ftpSite =  s.mid( start, (end - 2)- start );
								if(ftpSite.right(1) != "/")
								{
										ftpSite += "/";
								}
								ftpList += ftpSite + "\n";
								QListBox_1->insertItem ( ftpSite);
						}
				} // end while loop

				f2.open( IO_ReadWrite);
				f2.writeBlock( ftpList, ftpList.length() + 1);
				f.close();
				f2.close();
		}
		remove(file_name);
}

void ftpSiteDlg::openSiteList()
{
//ListFile = ( QDir::homeDirPath ()) +"/.kgutenbook/ftpList";
		QFile f( ListFile);
		if (f.exists() )
		{
				if(!f.open( IO_ReadWrite ))
				{
						QMessageBox::message( (i18n("Note")), (i18n("File not opened sucessfully." )) );
				}
				else
				{
						QTextStream t( &f);
						while ( !t.eof() )
						{
								QString ftpSite = t.readLine();
								QListBox_1->insertItem ( ftpSite);
						} // end while loop
						f.close();
				}
		}
		else
		{
				QMessageBox::message( "Kgutenbook", (i18n("You must download the ftp site list")) );		
				getSite();
		}
// ListFile				
}
		
void ftpSiteDlg::getSelection()
{
		select_site( QListBox_1->text( QListBox_1->currentItem() ));
}
