// $Id: connectbutton.cpp,v 1.3 1998/12/08 16:09:37 denis Exp $
// $Log: connectbutton.cpp,v $
// Revision 1.3  1998/12/08 16:09:37  denis
// Cleaned up a little before releasing
//

#include <qpainter.h>
#include <qpixmap.h>
#include "connectbutton.h"
#include "mainwindow.h"

#include "connectbutton.moc"

ConnectButton::ConnectButton(QWidget *parent, const char *name) : QPushButton(parent, name)
{
  timerid = -1;
  loader = kapp->getIconLoader();
  setStatus(stOffline);
}

ConnectButton::~ConnectButton()
{
  killTimers();
}

void ConnectButton::drawButtonLabel(QPainter *p)
{
  p->drawPixmap(6, 4, lpixmap);
  p->drawText(lpixmap.width()+13, 0, width()-13-lpixmap.width(), height(), AlignLeft|AlignVCenter, ltext);
}

void ConnectButton::setStatus(icqStatus status)
{
  switch(status)
  {
    case stOnline:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("online.xpm");
      ltext = "Online";
      break;
    case stAway:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("away.xpm");
      ltext = "Away";
      break;
    case stDND:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("dnd.xpm");
      ltext = "DND";
      break;
    case stNA:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("na.xpm");
      ltext = "N/A";
      break;
    case stOccupied:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("occupied.xpm");
      ltext = "Occupied";
      break;
    case stFFC:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("freechat.xpm");
      ltext = "Free Chat";
      break;
    case stInvisible:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("privacy.xpm");
      ltext = "Privacy";
      break;
    case stOffline:
      if(timerid!=-1)
      {
        killTimer(timerid);
        timerid = -1;
      }
      lpixmap = loader->loadIcon("offline.xpm");
      ltext = "Offline";
      break;
    case stLogin:
      if(timerid==-1)
      {
        picnum = 1;
        lpixmap = loader->loadIcon("connect1.xpm");
        ltext = "Connecting";
        timerid = startTimer(1000);
      }
      break;
  }
  ((MainWindow*)(kapp->topWidget()))->setIcon(lpixmap);
  update();
}

void ConnectButton::timerEvent(QTimerEvent *te)
{
  QString filename;
  if(te->timerId()==timerid)
  {
    picnum++;
    if(picnum>8)
      picnum = 1;
    filename.sprintf("connect%i.xpm", picnum);
    lpixmap = loader->loadIcon(filename);
    ((MainWindow*)(kapp->topWidget()))->setIcon(lpixmap);
    update(6, 4, lpixmap.width(), lpixmap.height());
  }
}
