// $Id: docking.cpp,v 1.5 1998/12/08 16:15:03 denis Exp $
// $Log: docking.cpp,v $
// Revision 1.5  1998/12/08 16:15:03  denis
// setToolTip added
// Cleaned up a little before releasing
//

#include <kwm.h>
#include <kapp.h>
#include <qtooltip.h>
#include "mainwindow.h"
#include "docking.h"

#include "docking.moc"

DockWidget::DockWidget() : QWidget()
{
  docked = FALSE;
  doRemove = FALSE;
  dockPopup = new QPopupMenu();
  toggleID = dockPopup->insertItem("Restore", this, SLOT(showWindow()));
  dockPopup->insertItem("Status", ((MainWindow*)(kapp->topWidget()))->stateMenu());
  dockPopup->insertItem("Shutdown", this, SLOT(emitQuit()));
  QToolTip::add(this, "kicq");
}

DockWidget::~DockWidget()
{
}

void DockWidget::dock()
{
  if(!docked)
  {
    KWM::setDockWindow(this->winId());
    this->setFixedSize(24, 24);
    show();
    paintIcon();
    update();
    docked = TRUE;
  }
}

void DockWidget::undock()
{
  if(docked)
  {
    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough.
    this->destroy(TRUE, TRUE);
    // recreate window for further dockings
    this->create(0, TRUE, FALSE);
    docked = FALSE;
  }
}

const int DockWidget::isDocked()
{
  return docked;
}

void DockWidget::paintEvent(QPaintEvent*)
{
  paintIcon();
}

void DockWidget::paintIcon()
{
  bitBlt(this, (24-dockIcon.width())/2, (24-dockIcon.height())/2, &dockIcon);
}

void DockWidget::mouseDoubleClickEvent(QMouseEvent *e)
{
  if(e->button() == LeftButton)
  {
    if(((MainWindow*)(kapp->topWidget()))->isUnreadMsgs())
      ((MainWindow*)(kapp->topWidget()))->readFirstRequest();
    else
      showWindow();
  }
}

void DockWidget::mousePressEvent(QMouseEvent *e)
{
  if(e->button() == RightButton || e->button() == MidButton)
  {
    int x = e->x();
    int y = e->y();
    QString text;
    if(((MainWindow*)(kapp->topWidget()))->isUnreadMsgs())
    {
      if(!doRemove)
      {
        int readID = dockPopup->insertItem("Read Message", -1, 0);
        dockPopup->connectItem(readID, kapp->topWidget(), SLOT(readFirstRequest()));
        dockPopup->insertSeparator(1);
        doRemove = TRUE;
      }
    }
    else
      if(doRemove)
      {
        dockPopup->removeItemAt(1);
        dockPopup->removeItemAt(0);
        doRemove = FALSE;
      }
    if(((MainWindow*)(kapp->topWidget()))->isVisible())
    {
      text = "Dock";
      dockPopup->disconnectItem(toggleID, this, SLOT(showWindow()));
      dockPopup->connectItem(toggleID, this, SLOT(hideWindow()));
    }
    else
    {
      text = "Restore";
      dockPopup->disconnectItem(toggleID, this, SLOT(hideWindow()));
      dockPopup->connectItem(toggleID, this, SLOT(showWindow()));
    }
    dockPopup->changeItem(text, toggleID);
    dockPopup->popup(mapToGlobal(QPoint(x, y)));
    dockPopup->exec();
  }
}

void DockWidget::hideWindow()
{
  if(((MainWindow*)(kapp->topWidget()))->isVisible())
    ((MainWindow*)(kapp->topWidget()))->hide();
}

void DockWidget::showWindow()
{
  if(!((MainWindow*)(kapp->topWidget()))->isVisible())
    ((MainWindow*)(kapp->topWidget()))->show();
}

void DockWidget::emitQuit()
{
  emit quitClicked();
}

void DockWidget::setIcon(QPixmap icon)
{
  dockIcon = icon;
  update();
}

void DockWidget::setToolTip(QString text)
{
  QToolTip::remove(this);
  QToolTip::add(this, (const char*)text);
}
