// $Id: historywin.cpp,v 1.9 1998/12/08 16:16:22 denis Exp $
// $Log: historywin.cpp,v $
// Revision 1.9  1998/12/08 16:16:22  denis
// Cleaned up a little before releasing
//
// Revision 1.8  1998/11/25 12:03:53  denis
// Trying to catch QGDict::look: Attempt to insert null item
//

#include <kapp.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qmovie.h>
#include <qregexp.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfileinf.h>
#include <qmsgbox.h>
#include <unistd.h>
#include "historywin.h"
#include "recvwindow.h"
#include "mainwindow.h"

#include "historywin.moc"

HistoryWindow::HistoryWindow(unsigned long u) : QDialog()
{
  uin = u ;
  ContactItem *item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(uin) ;

  QString caption ;
  caption.sprintf("History Events of: %s",(const char *)item->nick) ;
  setCaption((const char *)caption) ;

  msgList.setAutoDelete(TRUE) ;

  closebtn = new QPushButton("Close",this) ;
  connect(closebtn,SIGNAL(clicked()),SLOT(closeCmd())) ;

  deletebtn = new QPushButton("Delete",this) ;
  deletebtn->setEnabled(FALSE) ;
  connect(deletebtn,SIGNAL(clicked()),SLOT(deleteCmd())) ;

  deleteallbtn = new QPushButton("Delete All",this) ;
  connect(deleteallbtn,SIGNAL(clicked()),SLOT(deleteAllCmd())) ;

  findbtn = new QPushButton("Find",this) ;
  findbtn->setEnabled(FALSE) ;
  // Reserved for future releases :)
  // connect(findbtn,SIGNAL(clicked()),SLOT(findCmd())) ; 

  saveasbtn = new QPushButton("Save As",this) ;
  saveasbtn->setEnabled(FALSE) ;
  // Reserved for future releases :)
  // connect(saveasbtn,SIGNAL(clicked()),SLOT(saveAsCmd())) ; 

  orderbtn = new QCheckBox("Show most recent event first",this) ;
  orderbtn->setChecked(TRUE) ;
  connect(orderbtn,SIGNAL(clicked()),SLOT(refresh())) ;

  tabctl = new KTabCtl(this) ;

  allevents = new AllEventsWidget(tabctl) ;
  inevents = new InOutEventsWidget(tabctl,MSG_IN) ;
  outevents = new InOutEventsWidget(tabctl,MSG_OUT) ;
  
  tabctl->addTab(allevents,"All Events") ;
  tabctl->addTab(inevents,"Incoming Events") ;
  tabctl->addTab(outevents,"Outgoing Events") ;
  connect(tabctl,SIGNAL(tabSelected(int)), SLOT(changeTab(int)));

  curtab = 0 ;

  refresh() ;
  resize(630,340) ;
  setMinimumSize(630,340);
}

HistoryWindow::~HistoryWindow()
{
  msgList.clear() ;
  if(closebtn)
    delete closebtn;
  if(allevents)
    delete allevents ;
  if(orderbtn)
    delete orderbtn ;
  if(deletebtn)
    delete deletebtn ;
  if(deleteallbtn)
    delete deleteallbtn ;
  if(findbtn)
    delete findbtn ;
  if(saveasbtn)
    delete saveasbtn ;
}

void HistoryWindow::resizeEvent(QResizeEvent *re)
{
  QDialog::resizeEvent(re);

  QSize closesize,ordersize,deletesize,deleteallsize,findsize,saveassize ;

  ordersize = orderbtn->sizeHint() ;
  closesize = closebtn->sizeHint() ;
  deletesize = deletebtn->sizeHint() ;
  deleteallsize = deleteallbtn->sizeHint() ;
  findsize = findbtn->sizeHint() ;
  saveassize = saveasbtn->sizeHint() ;

  tabctl->setGeometry(10,10,width()-20,height()-70);

  closebtn->setGeometry(width() - 15 - closesize.width(),height() - closesize.height() - 12,
    closesize.width(),closesize.height()) ;

  findbtn->setGeometry(20,height() - findsize.height() - 12,
    findsize.width(),findsize.height()) ;

  saveasbtn->setGeometry(20 + findsize.width() + 5,height() - saveassize.height() - 12,
    saveassize.width(),saveassize.height()) ;

  deletebtn->setGeometry(20 + findsize.width() + 5 + saveassize.width() + 5,
    height() - deletesize.height() - 12,
    deletesize.width(),deletesize.height()) ;

  deleteallbtn->setGeometry(20 + findsize.width() + 5 + saveassize.width() + 5 + deletesize.width() + 5,
    height() - deleteallsize.height() - 12,
    deleteallsize.width(),deleteallsize.height()) ;

  orderbtn->setGeometry(20 + findsize.width() + 5 + saveassize.width() + 5 + deletesize.width() +
    5 + deleteallsize.width() + 10,height()-ordersize.height()-15,
    ordersize.width(),ordersize.height()) ;
}

void HistoryWindow::listSelected()
{
  deletebtn->setEnabled(TRUE) ;
}

void HistoryWindow::closeCmd()
{
  hide();
  ((MainWindow*)(kapp->topWidget()))->delHistoryWin(this);
}

void HistoryWindow::deleteCmd()
{
  int n ;

  switch(curtab)
  {
    case 0:
      n = allevents->currentItem() ;
      break ;

    case 1:
      n = inevents->currentItem() ;
      break ;

    case 2:
      n = outevents->currentItem() ;
      break ;

    default:
      n = -1 ;
  }

  if(n == -1) return ;

  if(QMessageBox::warning(this, "Confirm", 
    "Are you sure you want to delete this event?", QMessageBox::Yes, 
    QMessageBox::No) != QMessageBox::Yes) return ;

  if(orderbtn->isChecked())
  {
    msgList.remove(n) ;
  }
  else
  {
    msgList.remove(msgList.count() - n - 1) ;
  }

  QString strUin ;
  strUin.setNum(uin) ;

  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() 
    + "/" + strUin + ".history" ;

  QFile hfile(historypath) ;
  QFileInfo hinfo(hfile) ;

  if(!hinfo.isWritable())
  {
    QMessageBox::warning(this,"Error","Cannot write to history file") ;
    return ;
  }

  unlink(hfile.name());

  icqMessage *ptr ;
  for(ptr = msgList.first() ; ptr != 0L ; ptr = msgList.next())
    ptr->save(((MainWindow*)(kapp->topWidget()))->contactsDir()) ;

  refresh() ;
}

void HistoryWindow::deleteAllCmd()
{
  if(QMessageBox::warning(this, "Confirm", 
    "Are you sure you want to delete ALL events?", QMessageBox::Yes, 
    QMessageBox::No) == QMessageBox::No) return ;

  QString strUin ;
  strUin.setNum(uin) ;

  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() 
    + "/" + strUin + ".history" ;

  QFile hfile(historypath) ;
  QFileInfo hinfo(hfile) ;

  if(!hinfo.isWritable())
  {
    QMessageBox::warning(this,"Error","Cannot write to history file") ;
    return ;
  }

  unlink(hfile.name());
  refresh() ;
}

void HistoryWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
  ((MainWindow*)(kapp->topWidget()))->delHistoryWin(this);
}

void HistoryWindow::changeTab(int tab)
{
  curtab = tab ;
  refresh() ;
}

void HistoryWindow::showDetail()
{
  int n ;

  switch(curtab)
  {
    case 0:
      n = allevents->currentItem() ;
      break ;

    case 1:
      n = inevents->currentItem() ;
      break ;

    case 2:
      n = outevents->currentItem() ;
      break ;

    default:
      n = -1 ;
  }

  if(n == -1)
    return ;
  
  if(!orderbtn->isChecked())
    n = msgList.count() - n - 1 ;

  RecvWindow *rw = new RecvWindow(&msgList,n,UIN(),FALSE) ;
  rw->show() ;
}

void HistoryWindow::refresh()
{
  readHistory() ;

  ascending = orderbtn->isChecked() ;  

  switch(curtab)
  {
    case 0:
      allevents->refresh(&msgList,ascending) ;
      break ;

    case 1:
      inevents->refresh(&msgList,ascending) ;
      break ;

    case 2:
      outevents->refresh(&msgList,ascending) ;
      break ;

    default:
      break ;
  }
}

void HistoryWindow::readHistory()
{
  static char *types[] = { "Unknown", "Message Sent", "Message Received",
                         "URL Sent", "URL Received", "Authorization Requested",
                         "Authorization Granted", "Authorization Refused" } ;

  char *msg_types[32] ;

  msg_types[MSG_UNDEF] = types[0] ;
  msg_types[MSG_SENT] = types[1] ;
  msg_types[MSG_RECV] = types[2] ;
  msg_types[MSG_URL_SENT] = types[3] ;
  msg_types[MSG_URL_RECV] = types[4] ;
  msg_types[MSG_AUTH_RECV] = types[5] ;
  msg_types[MSG_AUTH_GRANT] = types[6] ;
  msg_types[MSG_AUTH_REFUSE] = types[7] ;

  msgList.clear() ;

  QString strUin ;
  strUin.setNum(uin) ;

  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() 
    + "/" + strUin + ".history" ;

  QFile hfile(historypath) ;

  if(!hfile.exists()) return ;

  hfile.open(IO_ReadOnly) ;

  QRegExp *r[8] ;
  QString re ;

  for(int i = 0 ; i < 8 ; i ++)
  {
    re = (QString)"\\[" + msg_types[i] + ".../../.......:..\\]";
    r[i] = new QRegExp(re) ;
  }

  int i, c, pos, type = -1 ;
  QString s, nextmsg ;
  TimeStr nexttime ;  

  do
  {
    char buffer[512] ;
    c = hfile.readLine((char *)&buffer,512) ;

    s = buffer ;

    for(i = 0 ; i < 8 ; i ++)
    {
      if((pos = r[i]->match(s)) != -1 || c == -1)
      {
        if(type != -1)
        {
          icqMessage *msg ;
          if(type == MSG_RECV || type == MSG_SENT)
          {
            msg = new icqMessage(uin,nexttime,(const char *)nextmsg,(icqMsgType)type) ;
          }
          else if(type == MSG_URL_RECV || type == MSG_URL_SENT)
          {
            QString url = (const char *)nextmsg ;
            url.remove(url.find('\n',0) + 1,url.length()) ;

            nextmsg.remove(0,nextmsg.find('\n',0) + 1) ;
            msg = new icqMessage(uin,nexttime,(const char *)url,(const char *)nextmsg,(icqMsgType)type) ;
          }
          else
            msg = new icqMessage(0,nexttime,"unknown\n",MSG_UNDEF) ;

          msgList.append(msg) ;
          if(c == -1) break ;
        }
        if(c != -1)
        {
          type = i ;
          nextmsg.resize(0) ;

          QString timestr = s.right(s.length() - pos) ;
          int day,month,year,hour,minute ;
          sscanf(timestr,"%*s %*s %02d/%02d/%04d %02d:%02d]",&day,&month,&year,
            &hour,&minute) ;
          nexttime.day = day ;
          nexttime.month = month ;
          nexttime.year = year ;
          nexttime.minute = minute ;
          nexttime.hour = hour ;
          break ;
        }
      }
    }
    if(i == 8)
    {
      nextmsg += s ;
    }
  } while(c != -1) ;
    
  hfile.close() ;

  for(i = 0 ; i < 8 ; i ++)
    delete r[i] ;
}

unsigned long HistoryWindow::UIN() const 
{
  return uin ;
}

AllEventsWidget::AllEventsWidget(QWidget *p) : QWidget(p)
{

#ifdef USE_LISTVIEW

  msglist = new QListView(this) ;
  msglist->addColumn("Event",120) ;
  msglist->addColumn("Date",110) ;
  msglist->addColumn("Message",349) ;
  msglist->setAllColumnsShowFocus(TRUE) ;
  msglist->setFocus() ;

  connect(msglist,SIGNAL(doubleClicked(QListViewItem *)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(returnPressed(QListViewItem *)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(selectionChanged()),p->parent(),SLOT(listSelected())) ;

#else

  msglist = new QListBox(this) ;
  msglist->setFocus() ;

#if(QT_VERSION >= 140)  
  msghdr = new QHeader(this) ;

  msghdr->addLabel("Event",120) ;
  msghdr->addLabel("Date",110) ;
  msghdr->addLabel("Message",349) ;
  msghdr->setClickEnabled(FALSE,-1) ;
  msghdr->setResizeEnabled(FALSE,-1) ;
  msghdr->setMovingEnabled(FALSE) ;
#endif

  connect(msglist,SIGNAL(selected(int)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(highlighted(int)),p->parent(),SLOT(listSelected())) ;

#endif

}

AllEventsWidget::~AllEventsWidget()
{
  if(msglist) 
    delete msglist ;

#ifndef USE_LISTVIEW
#if(QT_VERSION >= 140)
  if(msghdr)
    delete msghdr ;
#endif
#endif
}

void AllEventsWidget::resizeEvent(QResizeEvent *ev)
{
  QWidget::resizeEvent(ev) ;

#ifdef USE_LISTVIEW

  msglist->setGeometry(3,3,width() - 6,height() - 6) ;

#else

#if(QT_VERSION >= 140)
  int hw = msghdr->sizeHint().height() ;
  msghdr->setGeometry(3,3,width() - 6,hw) ;
#else
  int hw = 0;
#endif

  msglist->setGeometry(3,3 + hw,width() - 6,height() - 6 - hw) ;

#endif

#if(QT_VERSION >= 140)
  QSize s = msglist->verticalScrollBar()->sizeHint() ;
#endif

#if(QT_VERSION >= 140)
  int w = msglist->width() - s.width() ;
  msglist->setColumnWidth(0,w < 480 ? w/4 : 120) ;
  msglist->setColumnWidth(1,w < 480 ? w/4 : 120 ) ;
  msglist->setColumnWidth(2,w > 480 ? w - 240 : 240) ;
#endif

#ifndef USE_LISTVIEW

  msglist->update() ;

#endif

}

int AllEventsWidget::currentItem()
{

#ifdef USE_LISTVIEW

  WMlineListBoxItem *i = (WMlineListBoxItem *)msglist->currentItem() ; 

  int n = atoi(i->text(3)) ;

#else

  int n = msglist->currentItem() ;

#endif

  return n ;
}

void AllEventsWidget::refresh(QList<icqMessage> *l,int asc)
{
#ifndef USE_LISTVIEW

  msglist->setAutoUpdate(FALSE) ;  
  int sel = msglist->currentItem() ;
  msglist->clearSelection() ;

#endif

  msglist->clear() ;

  KIconLoader *il = new KIconLoader() ;

  icqMessage *ptr ;

#ifdef USE_LISTVIEW
  int n = 0 ;
#endif

  for(ptr = (asc ? l->first() : l->last()) ; ptr != 0L ; 
    ptr = (asc ? l->next() : l->prev()))
  {
    QString icon, event ;
    QString body = ptr->body() ;

    switch(ptr->type())
    {
      case MSG_SENT:
        event = "\nMessage Sent\n" ;
        icon = "message.xpm" ;
        break ;
      case MSG_RECV:
        event = "\nMessage Received\n" ;
        icon = "message.xpm" ;
        break ;

      case MSG_URL_SENT:
        event = "\nURL Sent\n" ;
        icon = "url.xpm" ;
        body = (QString)ptr->url() + "\n" + body ;
        break ;
      case MSG_URL_RECV:
        event = "\nURL Received\n" ;
        icon = "url.xpm" ;
        body = (QString)ptr->url() + "\n" + body ;
        break ;

      default:
        icon = "null.xpm" ;
    }

    QPixmap pm = il->loadIcon(icon) ;

    TimeStr t = ptr->time() ;
    QString ts ;
    ts.sprintf("%02i/%02i/%04i %02i:%02i\n",t.day,t.month,t.year,t.hour,t.minute) ;

#ifdef USE_LISTVIEW

    WMlineListBoxItem *litem = new WMlineListBoxItem(msglist,2) ;

    litem->setPixmap(0,pm) ;
    litem->setText(0,(const char *)event) ;
    litem->setText(1,(const char *)ts) ;
    litem->setText(2,body) ;
    QString num ;
    num.setNum(n) ;
    litem->setText(3,(const char *)num) ;
    n ++ ;

#else

    WMlineListBoxItem *litem = new WMlineListBoxItem(2) ;

    litem->setColumnWidth(0,120) ;
    litem->setColumnWidth(1,110) ;
    litem->setColumnWidth(2,340) ;

    litem->setPixmap(0,pm) ;
    litem->setText(0,(const char *)event) ;
    litem->setText(1,(const char *)ts) ;
    litem->setText(2,body) ;

    msglist->insertItem((QListBoxItem *)litem,0) ;

#endif

  }

#ifndef USE_LISTVIEW

  if(l->count())
    msglist->setCurrentItem(sel) ;
  msglist->setAutoUpdate(TRUE) ;
  msglist->update() ;

#endif 

}

InOutEventsWidget::InOutEventsWidget(QWidget *p,InOut d) : QWidget(p)
{

  direction = d ;

#ifdef USE_LISTVIEW

  msglist = new QListView(this) ;
  msglist->addColumn("Event",80) ;
  msglist->addColumn("Time",70) ;
  msglist->addColumn("Date",80) ;
  msglist->addColumn("Message",250) ;
  msglist->setAllColumnsShowFocus(TRUE) ;
  msglist->setFocus() ;

  connect(msglist,SIGNAL(doubleClicked(QListViewItem *)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(returnPressed(QListViewItem *)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(selectionChanged()),p->parent(),SLOT(listSelected())) ;

#else

  msglist = new QListBox(this) ;
  msglist->setFocus() ;
  
  msghdr = new QHeader(this) ;

  msghdr->addLabel("Event",80) ;
  msghdr->addLabel("Time",70) ;
  msghdr->addLabel("Date",80) ;
  msghdr->addLabel("Message",250) ;
  msghdr->setClickEnabled(FALSE,-1) ;
  msghdr->setResizeEnabled(FALSE,-1) ;
  msghdr->setMovingEnabled(FALSE) ;

  connect(msglist,SIGNAL(selected(int)),p->parent(),SLOT(showDetail())) ;
  connect(msglist,SIGNAL(highlighted(int)),p->parent(),SLOT(listSelected())) ;

#endif

}

InOutEventsWidget::~InOutEventsWidget()
{
  if(msglist) 
    delete msglist ;

#ifndef USE_LISTVIEW
  if(msghdr)
    delete msghdr ;
#endif
}

void InOutEventsWidget::resizeEvent(QResizeEvent *ev)
{
  QWidget::resizeEvent(ev) ;

#ifdef USE_LISTVIEW

  msglist->setGeometry(3,3,width() - 6,height() - 6) ;

#else

  int hw = msghdr->sizeHint().height() ;
  msghdr->setGeometry(3,3,width() - 6,hw) ;
  msglist->setGeometry(3,3 + hw,width() - 6,height() - 6 - hw) ;

#endif

  QSize s = msglist->verticalScrollBar()->sizeHint() ;
  int w = msglist->width() - s.width() ;
  msglist->setColumnWidth(0,w < 480 ? w/6 : 80) ;
  msglist->setColumnWidth(1,w < 480 ? w/6 : 70) ;
  msglist->setColumnWidth(2,w < 480 ? w/6 : 80) ;
  msglist->setColumnWidth(3,w > 480 ? w - 230 : 250) ;

#ifndef USE_LISTVIEW

  msglist->update() ;

#endif

}

int InOutEventsWidget::currentItem()
{
  int n ;

#ifdef USE_LISTVIEW

  WMlineListBoxItem *i = (WMlineListBoxItem *)msglist->currentItem() ; 

  n = atoi(i->text(4)) ;

#else

  n = atoi(numlist.at(msglist->currentItem())) ;

#endif

  return n ;
}

void InOutEventsWidget::refresh(QList<icqMessage> *l,int asc)
{

#ifndef USE_LISTVIEW

  msglist->setAutoUpdate(FALSE) ;  
  int sel = msglist->currentItem() ;
  msglist->clearSelection() ;
  numlist.clear() ;

#endif

  msglist->clear() ;

  KIconLoader *il = new KIconLoader() ;

  QPixmap pm ;
  QPixmap pmap_url = il->loadIcon("url.xpm") ;
  QPixmap pmap_msg = il->loadIcon("message.xpm") ;

  icqMessage *ptr ;
  int n = 0 ;

  for(ptr = (asc ? l->first() : l->last()) ; ptr != 0L ; 
    ptr = (asc ? l->next() : l->prev()))
  {
    QString icon, event ;
    QString body = ptr->body() ;

    if((direction == MSG_IN && 
      (ptr->type() == MSG_SENT || ptr->type() == MSG_URL_SENT)) ||
      (direction == MSG_OUT &&
      (ptr->type() == MSG_RECV || ptr->type() == MSG_URL_RECV)))
    {
      n ++ ;
      continue ;
    }

    switch(ptr->type())
    {
      case MSG_SENT:
      case MSG_RECV:
        event = "Message\n" ;
        pm = pmap_msg ;
        break ;

      case MSG_URL_SENT:
      case MSG_URL_RECV:
        event = "URL\n" ;
        pm = pmap_url ;
        body = (QString)ptr->url() + "\n" + body ;
        break ;

      default:
        icon = "null.xpm" ;
    }

    TimeStr t = ptr->time() ;
    QString date, time ;
    date.sprintf("%02i/%02i/%04i\n",t.day,t.month,t.year) ;
    time.sprintf("%02i:%02i\n",t.hour,t.minute) ;

    QString num ;
    num.setNum(n) ;

#ifdef USE_LISTVIEW

    WMlineListBoxItem *litem = new WMlineListBoxItem(msglist,1) ;
    litem->setText(4,(const char *)num) ;

#else

    WMlineListBoxItem *litem = new WMlineListBoxItem(1) ;

    litem->setColumnWidth(0,80) ;
    litem->setColumnWidth(1,70) ;
    litem->setColumnWidth(2,80) ;
    litem->setColumnWidth(3,250) ;
    numlist.insert((const char *)num,0) ; 

#endif

    litem->setPixmap(0,pm) ;
    litem->setText(0,(const char *)event) ;
    litem->setText(1,(const char *)time) ;
    litem->setText(2,(const char *)date) ;
    litem->setText(3,(const char *)body) ;

    n ++ ;

#ifndef USE_LISTVIEW
    msglist->insertItem((QListBoxItem *)litem,0) ;
#endif

  }

#ifndef USE_LISTVIEW

  if(l->count()) msglist->setCurrentItem(sel) ;
  msglist->setAutoUpdate(TRUE) ;
  msglist->update() ;

#endif 

}
