#ifndef _HISTORYWIN_
#define _HISTORYWIN_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpushbt.h>
#include <qchkbox.h>
#include <qdialog.h>
#include <qlist.h>

#ifdef USE_LISTVIEW
#include <qlistview.h>
#else
#include <qlistbox.h>
#endif

#if(QT_VERSION >= 140)
#include <qheader.h>
#endif

#include <ktabctl.h>
#include "icqmessage.h"
#include "mlinelistbox.h"

enum InOut { MSG_IN, MSG_OUT } ;

class AllEventsWidget : public QWidget
{
public:
  AllEventsWidget(QWidget *) ;
  ~AllEventsWidget();
  void refresh(QList<icqMessage> *,int) ;
  int currentItem() ;
protected:
  void resizeEvent(QResizeEvent *) ;

#ifdef USE_LISTVIEW
  QListView *msglist ;
#else
  QListBox *msglist ;

#if(QT_VERSION >= 140)
  QHeader *msghdr ; 
#endif /* QT_VERSION */

#endif /* USE_LISTVIEW */

} ;

class InOutEventsWidget : public QWidget
{
public:

  InOutEventsWidget(QWidget *,InOut) ;
  ~InOutEventsWidget();
  
  void refresh(QList<icqMessage> *,int) ;
  int currentItem() ;
  
protected:

  void resizeEvent(QResizeEvent *) ;
  
#ifdef USE_LISTVIEW
  QListView *msglist ;
#else
  QListBox *msglist ;
  QHeader *msghdr ;
  QStrList numlist ;
#endif

  InOut direction ;

} ;

class HistoryWindow : public QDialog {
  Q_OBJECT
public:
  HistoryWindow(unsigned long);
  ~HistoryWindow();
  unsigned long UIN() const ;
public slots:
  void refresh() ;
  void listSelected() ;
  void showDetail() ;
signals:
protected:
  unsigned long uin;
  int ascending, curtab ;
  KTabCtl *tabctl ;
  AllEventsWidget *allevents ;
  InOutEventsWidget *inevents, *outevents ;
  QPushButton *closebtn, *deletebtn, *deleteallbtn, *findbtn, *saveasbtn ;
  QCheckBox *orderbtn ;
  QList<icqMessage> msgList ;
  void readHistory() ;
  void resizeEvent(QResizeEvent *);
  void closeEvent(QCloseEvent *);
protected slots:
  void changeTab(int) ;
  void closeCmd() ;
  void deleteCmd() ;
  void deleteAllCmd() ;
private:
private slots:
};

#endif /* _HISTORYWIN_ */
