#ifndef _PREFPROXY_
#define _PREFPROXY_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kintegerline.h>
#include <qlabel.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qchkbox.h>

class ProxyWidget : public QWidget {
  Q_OBJECT
public:
  ProxyWidget(QWidget *);
  ~ProxyWidget();
  void setInfo(int, const char*, int, int, const char*, const char*);
  int use();
  const char *host();
  int port();
  int auth();
  const char *user();
  const char *pass();
public slots:
signals:
protected:
  QLabel *mainlabel, *hostlabel, *portlabel, *userlabel, *passlabel;
  QLineEdit *hostline, *userline, *passline;
  KIntegerLine *portline;
  QCheckBox *usebox, *authbox;
  QGroupBox *proxybox;
  void resizeEvent(QResizeEvent*);
protected slots:
  void useToggled(bool);
  void authToggled(bool);
private:
private slots:
};
#endif /* _PREFPROXY_ */
