// $Id: prefsound.cpp,v 1.4 1998/12/08 16:28:03 denis Exp $
// $Log: prefsound.cpp,v $
// Revision 1.4  1998/12/08 16:28:03  denis
// Cleaned up a little before releasing
//
// Revision 1.3  1998/11/23 10:09:03  denis
// Cleaned a little
//

#include "prefsound.h"

#include "prefsound.moc"

SoundWidget::SoundWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Sound Settings:",this);
  soundbox = new QGroupBox("Sound", this);
  bellbox = new QCheckBox("Beep on new messages", this);
  wavbox = new QCheckBox("Play sound", this);
  wavbox->setEnabled(FALSE);
  userbox = new QCheckBox("Play sound for ... whom? ;)", this);
  userbox->setEnabled(FALSE);
}

SoundWidget::~SoundWidget()
{
  if(mainlabel)
    delete mainlabel;
  if(bellbox)
    delete bellbox;
  if(wavbox)
    delete wavbox;
  if(userbox)
    delete userbox;
  if(soundbox)
    delete soundbox;
}

void SoundWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, bellboxsize, wavboxsize, userboxsize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  soundbox->setGeometry(7,30,width()-13,height()-37);
  bellboxsize = bellbox->sizeHint();
  wavboxsize = wavbox->sizeHint();
  userboxsize = userbox->sizeHint();
  int h = QMAX(QMAX(bellboxsize.height(),wavboxsize.height()),userboxsize.height());
  int w = QMAX(QMAX(bellboxsize.width(),wavboxsize.width()),userboxsize.width());
  bellbox->resize(w, h);
  wavbox->resize(w, h);
  userbox->resize(w, h);
  int mh = (soundbox->height()-20)/3;
  bellbox->move(15,soundbox->y()+mh/2-h/2+15);
  wavbox->move(15,soundbox->y()+mh+mh/2-h/2+15);
  userbox->move(15,soundbox->y()+mh*2+mh/2-h/2+15);
}

void SoundWidget::setInfo(int beep, int wav, int user)
{
  bellbox->setChecked(beep);
  wavbox->setChecked(wav);
  userbox->setChecked(user);
}

int SoundWidget::bell()
{
  return bellbox->isChecked();
}

int SoundWidget::wav()
{
  return wavbox->isChecked();
}

int SoundWidget::user()
{
  return userbox->isChecked();
}
