#ifndef _RECVWINDOW_
#define _RECVWINDOW_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <time.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qmlined.h>
#include <qlined.h>
#include "useritem.h"

class RecvWindow : public QDialog {
  Q_OBJECT
public:
  RecvWindow(QList<icqMessage> *,int,unsigned long,int);
  ~RecvWindow();
  void setMessage(const char*);
  void setURL(const char*);
  void setDescription(const char*);
  void setUIN(unsigned long);
  void setName(const char*);
  void setEMail(const char*);
  void setTime(TimeStr);
  unsigned long UIN();
  void updateNextAvailability();
public slots:
  void closeBtn();
signals:
protected:
  QString recvCaption;
  QList<icqMessage> *list ;
  int start, idx, delflag ;
  unsigned long msgUin ;
  QString nick;
  QString email;
  QPushButton *replybtn, *closebtn, *nextbtn, *addbtn;
  QGroupBox *frombox, *msgbox, *respbox;
  QLabel *uinlabel, *handlelabel, *emaillabel, *datelabel, *timelabel, *urllabel, *desclabel;
  QLineEdit *uinline, *handleline, *emailline, *dateline, *timeline, *urlline;
  QPushButton *infobutton;
  QMultiLineEdit *msgedit, *descedit;
  void resizeEvent(QResizeEvent *);
  void closeEvent(QCloseEvent *);
protected slots:
  void infoRequest();
  void addRequest();
  void replyRequest();
  void readNext() ;
private:
private slots:
};
#endif /* _RECVWINDOW_ */
