// $Id: systembar.cpp,v 1.3 1998/12/08 16:31:00 denis Exp $
// $Log: systembar.cpp,v $
// Revision 1.3  1998/12/08 16:31:00  denis
// Focus code removed
// Cleaned up a little before releasing
//

#include <qpopmenu.h>
#include <qpainter.h>
#include <kiconloader.h>
#include <kapp.h>
#include "useritem.h"
#include "systembar.h"

#include "systembar.moc"

SystemBar::SystemBar(QWidget *parent, const char *name, WFlags f) : QListBox(parent, name, f)
{
  QPalette pal = palette();
  QColorGroup colgrp = pal.normal();
  pal.setNormal(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),colgrp.dark(),colgrp.mid(),colgrp.text(),colgrp.background()));
  colgrp = pal.active();
  pal.setActive(QColorGroup(colgrp.foreground(),colgrp.background(),colgrp.light(),colgrp.dark(),colgrp.mid(),colgrp.text(),colgrp.background()));
  setPalette(pal);

  UserItem *useritem = new UserItem(tpSystem);
  insertItem(useritem);

  KIconLoader *il = kapp->getIconLoader();
  popup = new QPopupMenu();
  popup->insertItem(il->loadIcon("sendicq.xpm"),"Send ICQ Program To (N/A)", 1);
  popup->insertSeparator();
  popup->insertItem(il->loadIcon("wwpager.xpm"),"Send WWPager Address To (N/A)", 2);
	popup->setItemEnabled(1,FALSE);
	popup->setItemEnabled(2,FALSE);
}

SystemBar::~SystemBar()
{
  clear();
  if(popup)
  {
    popup->clear();
    delete popup;
  }
}

void SystemBar::paintCell(QPainter *p, int row, int)
{
  UserItem *lbi = (UserItem*)item(row);
  if(!lbi)
    return;

  QColorGroup g = colorGroup();
  {
    p->setBackgroundColor(g.base());
    p->setPen(g.text());
  }
  lbi->paint(p);
  p->setBackgroundColor(g.base());
  p->setPen(g.text());
}

void SystemBar::mousePressEvent(QMouseEvent *e)
{
  QListBox::mousePressEvent(e);
  if(e->button()==RightButton)
  {
    popup->popup(mapToGlobal(QPoint(e->x(),e->y())));
  }
}
