#include "kldap.h"

AttributeValueDialog::AttributeValueDialog(QWidget* parent, Kldapw* kldapw, int modifyType, char* dn, char* attributeName) : QDialog(parent, "Attribute Dialog", TRUE)
{
  this->kldapw = kldapw;
  this->modifyType = modifyType; // z.B. LDAP_MOD_ADD
  this->dn = dn; // z.B. oliver.mountpoint.ch
  this->attributeName = attributeName; // Name des zu modifizierenden Attributes

  setCaption("Add Value");

  QGridLayout* layout = new QGridLayout(this, 4, 3, 5);

  QLabel* lblValue = new QLabel("Value", this);

  QButtonGroup* btnGroup = new QButtonGroup(this);
  QVBoxLayout* vbox;vbox = new QVBoxLayout(btnGroup, 2);

  QRadioButton* rb[2];
  rb[0] = new QRadioButton("&text", btnGroup);
  vbox->addWidget(rb[0]);
  rb[1] = new QRadioButton("&binary", btnGroup);
  vbox->addWidget(rb[1]);
  vbox->activate();

  lblValue = new QLabel("Attribute Name", this);

  txtValue = new QLineEdit(this);
  QPushButton* btnOK = new QPushButton("&OK", this);
  QPushButton* btnCancel = new QPushButton("&Cancel", this);

  layout->addMultiCellWidget(btnGroup, 0, 1, 0, 0);
  layout->addWidget(lblValue, 2, 0);
  layout->addMultiCellWidget(txtValue, 2, 2, 1, 2);
  layout->addWidget(btnOK, 3, 1);
  layout->addWidget(btnCancel, 3, 2);

  btnGroup->setButton(0);
  txtValue->setFocus();

  QObject::connect(btnOK, SIGNAL(clicked()), SLOT(modify()));
  QObject::connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));
  QObject::connect(btnGroup, SIGNAL(clicked(int)), this, SLOT(valueTypeChanged(int)));
  QObject::connect(txtValue, SIGNAL(returnPressed()), this, SLOT(modify()));

  resize(300, 130);
}

void AttributeValueDialog::modify()
{
  char* mod_type = "";
  char* value = "";
  int error;

  value = (char*)txtValue->text();
  mod_type = attributeName;

  error = kldapw->modify(dn, modifyType, mod_type, value);

  if(error == 0)
  {
    accept();
  }
}

void AttributeValueDialog::valueTypeChanged(int type)
{
  if(type == 1)
  {
    txtValue->setEnabled(false);
  }
  else
  {
    txtValue->setEnabled(true);
  }
}