#include "kldap.h"

MainView::MainView(QWidget* parent) : QWidget(parent)
{
  QHBoxLayout* layout = new QHBoxLayout(this);
  panner = new KNewPanner(this);
  kldapw = new Kldapw(this);
  attributeWidget = new AttributeWidget(this);

  panner->activate(kldapw, attributeWidget);

  layout->addWidget(panner); // Extrem wichtig ;-)
}

void MainView::menuCallback(int id)
{
  SearchDialog* dlgSearch;

  switch(id)
    {
    case ID_EXIT:
      kapp->exit();
      break;

    case ID_CONNECT:
      attributeWidget->newWidget(new ConnectPage(attributeWidget, kldapw));
      break;

    case ID_ATTRIBUTE_LIST:
    attributeWidget->newWidget(new AttributeEditPage(attributeWidget, kldapw));
      break;
      
    case ID_DELETE:
      kldapw->deleteEntry();
      break;

    case ID_ADD:
      attributeWidget->newWidget(new AddPage(attributeWidget, kldapw));
      break;

    case ID_SEARCH:
      dlgSearch = new SearchDialog(this, kldapw);
      if(dlgSearch->result() == 0)
      {
        dlgSearch->show();
      }
      break;

    default:
      break;
    }
}

MainWidget::MainWidget(const char* name) : KTopLevelWidget(name)
{
  KIconLoader* loader = kapp->getIconLoader();
  MainView* mv = new MainView(this);

  KMenuBar *menubar = new KMenuBar(this);
  QPopupMenu* pmFile;
  QPopupMenu* pmEdit;
  QPopupMenu* pmConnect;
  pmFile = new QPopupMenu;
  pmEdit = new QPopupMenu;
  pmConnect = new QPopupMenu;
  pmFile->insertItem(klocale->translate("E&xit"), qApp, SLOT(quit()) );
  menubar->insertItem(klocale->translate("&File"), pmFile);
  pmEdit->insertItem(klocale->translate("Edit &attributes..."), ID_ATTRIBUTE_LIST);
  pmEdit->insertItem(klocale->translate("&Delete"), ID_DELETE);
  pmEdit->insertItem(klocale->translate("&Add..."), ID_ADD);
  pmEdit->insertItem(klocale->translate("&Search"), ID_SEARCH);
  pmConnect->insertItem(klocale->translate("Co&nnect..."), ID_CONNECT);
  QPopupMenu* pmHelp = kapp->getHelpMenu(FALSE, "kldap - Version 0.4,  written by Oliver Jaun\n<oliver@mountpoint.ch>");
  menubar->insertItem(klocale->translate("&Connect"), pmConnect);
  menubar->insertItem(klocale->translate("&Edit"), pmEdit);
  menubar->insertItem(klocale->translate("&Help"), pmHelp);

  KToolBar* toolbar = new KToolBar(this);
  toolbar->insertButton(loader->loadIcon("exit.xpm"), ID_EXIT, true, "Exit");
  toolbar->insertSeparator();
  toolbar->insertButton(loader->loadIcon("connect.xpm"), ID_CONNECT, true, "Connect");
  toolbar->insertButton(loader->loadIcon("attributelist.xpm"), ID_ATTRIBUTE_LIST, true, "Attribute list"); 
  toolbar->insertButton(loader->loadIcon("delete.xpm"), ID_DELETE, true, "Delete");
  toolbar->insertButton(loader->loadIcon("add.xpm"), ID_ADD, true, "Add");

  QObject::connect(toolbar, SIGNAL(clicked(int)), mv, SLOT(menuCallback(int)));
  QObject::connect(pmEdit, SIGNAL(activated(int)), mv, SLOT(menuCallback(int)));
  QObject::connect(pmConnect, SIGNAL(activated(int)), mv, SLOT(menuCallback(int)));
  this->resize(700, 500);

  setMenu(menubar); 
  addToolBar(toolbar);

  setView(mv);
}

int main(int argc, char** argv)
{
  KApplication a(argc, argv);
  MainWidget m;
  
  //m.setMinimumSize(400, 600);
  //m.setMaximumSize(400, 600);
  a.setMainWidget(&m);
  m.show();
  return a.exec();
}
