/***************************************************************************
                          mclient.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "mclient.h"

MClient::MClient(QWidget *parent = 0, const char *name = 0) : QWidget (parent, name){

	server_connection = false;

}
MClient::~MClient(){
}

/** Connect to the modem server */
void MClient::ServerConnect(const char *host, const char *sport){


 	int port = atoi(sport);
	struct sockaddr_in address;
	struct hostent *hostinfo;
	int result, len;
	char temp[1024];
	if (getlock())
	{
		if (server_connection == false)
		{
			if (host[0] == '\0')
			{
				strcpy(temp,"You must enter a hostname or IP address for the server.");
				emit ServerStatus(temp);
			}
			else if (port == 0)
			{
				strcpy(temp,"You must enter a port other than zero.");
				emit ServerStatus(temp);
			}
			else
			{
				sfd = socket (AF_INET, SOCK_STREAM, 0);

				hostinfo = gethostbyname(host);
				if (!hostinfo)
				{
					snprintf(temp, 1023, "Can not resolve host: %s", host);
					emit ServerStatus(temp);
				}
				else
				{
					if (hostinfo->h_addrtype != AF_INET)
					{
						snprintf(temp, 1023, "Not an IP host: %s", host);
						emit ServerStatus(temp);
					}
					else
					{
						address.sin_family = AF_INET;
						address.sin_addr = *(struct in_addr *) *hostinfo->h_addr_list;
						address.sin_port = htons(port);
	
						len = sizeof(address);
	
						result = cwrapper(&sfd, (struct sockaddr *) &address, &len);

						if (result == -1)
						{
							snprintf(temp, 1023, "Could not connect to server");
							emit ServerStatus(temp);
						}
						else
						{
							server_connection = true;
							snprintf(temp, 1023, "Connected to server");
							emit ServerStatus(temp);
							sock = fdopen (sfd, "r+");
							getready();
							List();
//							readStatus();
//							auth();
										
						}
					}
				}	
			}
		}
		else
		{
			fclose(sock);
			server_connection = false;
			strcpy(temp, "Closed Connection to the Server!");
			emit ServerStatus(temp);
		}
	}
	unlock();
}

/** Dial the given connection */
void MClient::Dial(const char *cname){

char temp[1024];

if (getlock())                          // Check the lock, if no lock then lock!
{
	if (server_connection == true)
			{
				fprintf(sock, "STAT\n");
				fgets(temp, 1023, sock);
				getready();
	
				if (strncmp(temp, "DOWN\n", 1023))
				{
					emit ServerStatus("A Connection is already established!");
				}
				else
				{
		
					fprintf(sock, "DIAL:%s\n", cname);
		
					char temp[1024];
					fgets(temp, 1023, sock);
					if (!strncmp(temp, "ERROR:\n", 6))
					{
						temp[strlen(temp) - 1] = '\0';
						emit ServerStatus(temp);
					}
					else if (!strncmp(temp, "BEGIN\n", 1023))
					{
						fgets(temp, 1023, sock);
						do
						{
							temp[strlen(temp) - 1] = '\0';
							emit ServerStatus(temp);
		
							fgets(temp, 1023, sock);
						}	
						while (strncmp(temp, "END\n", 1023));
						}
					getready();
					readStatus();
				}
			}
			else
			{
				emit ServerStatus("Not connected to server!");
			}
			unlock();                          // unlock!
	}
}	

/** Kill the current connection */
void MClient::Kill(){

        if (getlock())
        {
                if (server_connection)
                {
                        fprintf(sock, "KILL\n");

                        char temp[1024];
                        fgets(temp, 1023, sock);
                        if (!strncmp(temp, "ERROR:\n", 6))
                        {
                                temp[strlen(temp) - 1] = '\0';
                                emit ServerStatus(temp);
                        }
                        else if (!strncmp(temp, "SUCCESS\n", 1023))
                        {
                                emit ServerStatus("Successfully killed connection");
                        }
                        else
                        {
                                emit ServerStatus("Unknown response from server");
                        }

                        getready();
												emit DialedOut(false);
                }
                else
                {
                        emit ServerStatus("Not connected to server!");
                }
                unlock();
        }


}

/** Check if client is connected to server */
bool MClient::isConnected(){

	return server_connection;

}


/** Locks the connection */
bool MClient::getlock(){

 	if (islocked == true)
	{
		return false;
	}
	else
	{
		islocked = true;
		return true;
	}
}

/** Unlocks the connection
	*/

void MClient::unlock(){

	islocked = false;

}

/** Waits for a READY from the server  */

void MClient::getready(){
		char temp[1024];

	if (server_connection == true)
	{
		do
		{			
			fgets(temp, 1023, sock);
		}
		while (strncmp(temp, "READY\n", 1023));
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}

}






/** Reads the status from the server
	*/
void MClient::readStatus(){

if (getlock())
	{
		char temp[1024];
		char temp2[1024];
		char c[1024];
		char s[1024];
		unsigned int i, n;
 	
		if (server_connection == true)
		{
			fprintf(sock, "STAT\n");
			fgets(temp, 1023, sock);
			if (!strncmp(temp, "DOWN\n", 1023))
			{
				strcpy(temp2, "No active connections!");
				emit ServerStatus(temp2);
				getready();
			}
			else if (!strncmp(temp, "UP:\n", 3))
			{
				for (i = 3, n = 0; i < strlen(temp) && i < 1023 && temp[i] != ':'; i++, n++)
				{
					c[n] = temp[i];
				}
				c[n] = '\0';
 	
				for (i++, n = 0; i < strlen(temp) && i < 1023 && temp[i] != '\n'; i++, n++)
				{
					s[n] = temp[i];
				}
				s[n] = '\0';
 	
				snprintf(temp, 1023, "Connected to %s at %s", c, s);
				emit ServerStatus(temp);
				emit DialedOut(true);
 	      getready();
 	
		  }
		}
		else
		{
			emit ServerStatus("Not connected to server!");
			emit ServerStatus(temp);
			getready();
		}
		unlock();
	}
}

/** Reads the time of the connection being established from the server
  */
int MClient::readTime(){

char temp[1024];
QString *temp2;
int time;

if (getlock())
	{
	if (server_connection)
	{
	  fprintf(sock, "TIME\n");
		fgets(temp, 1023, sock);
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}
	getready();
	unlock();
	}
	temp2 = new QString(temp);
	time = temp2->toInt();
	return time;
}

/** Reads the current time from the server
	*/
int MClient::readCTime(){

char temp[1024];
QString *temp2;
int time;


if (getlock())
	{
	if (server_connection)
	{
	  fprintf(sock, "CTIME\n");
		fgets(temp, 1023, sock);
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}
	getready();
	unlock();
	}
	temp2 = new QString(temp);
	time = temp2->toInt();
	
	return time;
}

/** Reads the number of clients connected to the server
 */
int MClient::readCCount(){

char temp[1024];
QString *temp2;
int count;

if (getlock())
	{
	if (server_connection)
	{
	  fprintf(sock, "CCOUNT\n");
		fgets(temp, 1023, sock);
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}
	getready();
	unlock();
	}
	temp2 = new QString(temp);
	count = temp2->toInt();
	return count;
}

/** Reads what the server thinks your IP address is.
	*/
void MClient::readCIP(){

char temp[1024];

if (getlock())
	{
	if (server_connection)
	{
	  fprintf(sock, "CIP\n");
		fgets(temp, 1023, sock);
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}
	getready();
	unlock();
	}
}


/** Send auth name and password and make sure its valid
	*/

void MClient::getAuth(const char *user, const char *pass){

char temp[1024];

if(getlock())
{
	if (server_connection)
	{
		fprintf(sock, "USER:%s\n", user);
		fprintf(sock, "PASS:%s\n", pass);
		getready();
		fprintf(sock, "AUTH\n");
		fgets(temp, 1023, sock);
    if (!strncmp(temp, "NOT AUTHORIZED\n", 1023))
			{
				emit ServerStatus("Not Authorized");
			}
		else
			{
				emit ServerStatus("Authorized.\n");
			}
	}
	else
	{
		emit ServerStatus("Not connected to server!");
	}
	getready();
	unlock();
	}
}



/** Logs off the client from the server
 */
void MClient::sendQuit(){
if (getlock())
	{
	if (!server_connection)
		printf("Doh!\n");
	else
		fprintf(sock, "QUIT\n");
  }
	unlock();
}


/**  */
void MClient::List(){


if (getlock())
	{
	if (server_connection)
		{
		fprintf(sock, "LIST\n");
		char temp[1024];
		do
		{
			fgets(temp, 1023, sock);
		}
		while (strncmp(temp, "BEGIN\n", 1023));

		fgets(temp, 1023, sock);

		do
		{
			temp[strlen(temp) - 1] = '\0';
			emit NewConnection(temp);
			fgets(temp, 1023, sock);
		}
		while (strncmp(temp, "END\n", 1023));

		getready();

		}
	else
		{
		emit ServerStatus("Not connected to server.");
		}
		unlock();
	}
}



/**  */
QString *MClient::readCInfo(const char *cname){

QString *cinfo = new QString("");

if (getlock())
	{
	if (server_connection)
		{
		fprintf(sock, "CINFO:%s\n",cname);
		char temp[1024];
		do
		{
			fgets(temp, 1023, sock);
		}
		while (strncmp(temp, "BEGIN\n", 1023));

		fgets(temp, 1023, sock);

		do
		{
	 		temp[strlen(temp) - 1] = '\0';
			cinfo->append(temp);
			cinfo->append("~");
    	fgets(temp, 1023, sock);
		}
		while (strncmp(temp, "END\n", 1023));

		getready();

		}
	else
		{
		emit ServerStatus("Not connected to server.");
		}
		unlock();
	}
	return cinfo;
}


int cwrapper (int *sockfd, struct sockaddr *serv_addr, int *addrlen)
{
        return connect(*sockfd, serv_addr, *addrlen);
}



























