  /*

  knetfilter v 2.0.0

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"


// sending commands to set up rules
void knetfilter::addRule() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));
    
    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));
    
    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));


    addp.clearArguments();
    addp2.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char *)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }


    if(sport.length()==0 && dport.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or destination port number.\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
          if (dport.length()==0)
	{
	  addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	  addp2 << "iptables" << ruleaction << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	}
      else
	{
	  if (sport.length()==0)
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	  else
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	}
    };

    bool success=addp.start();
    bool success2=addp2.start();
    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_tcp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));


    addp.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(sport.length()==0 && dport.length()==0 ) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or destination port number.\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (dport.length()==0)
	{
	  addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	}
      else
	{
	  if (sport.length()==0)	
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      addp << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	}      
    };

    bool success=addp.start();
    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_udp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));

    addp2.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(sport.length()==0 && dport.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply a source or detination port number.\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      if (dport.length()==0)
	{
	  addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	}
      else
	{
	  if (sport.length()==0)	
	    {
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      addp2 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	}      
    };

    bool success2=addp2.start();

    if (success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::addRule_icmp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, type, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("32");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    type.sprintf((const char *)(addIcmpType->text()));

    addp3.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    rulepos.sprintf((const char *)(addRuleNumber->text()));
    if(rulepos.length()==0)
      {
	ruleaction="-A";
	rulepos.sprintf("-v");
      }
    else
      {
	ruleaction="-I";
      }

    if(type.length()==0) 
      QMessageBox::critical(0, "Error",
    			"You have to supply an icmp type number.\n");
    else if(ip.length()==0 && netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address,\n"
			"and a netmask address.\n");
    else if(ip.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a IP address.\n");
    else if(netmask.length()==0)
      QMessageBox::critical(0, "Error",
      			"You have to supply a netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid IP address.\n");
    else if(!strcmp(netmask,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
      			"Not a valid netmask address.\n");
    else {
      addp3 << "iptables" << ruleaction << chainChoice << rulepos << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
    };

    bool success=addp3.start();
    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::delRule() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp.clearArguments();
    delp2.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp << "iptables" << "-D" << chainChoice << rulepos;
	delp2;	  
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(ip.length()==0 && netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address,\n"
				"and a netmask address.\n");
	else if(ip.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address.\n");
	else if(netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
    else if(!strcmp(ip,"Couldn't probe"))
      QMessageBox::critical(0, "Error",
			    "Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (dport.length()==0)
	    {
	      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	    }
	  else
	    {
	      if (sport.length()==0)
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	      else
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }
	}
      };

    bool success=delp.start();
    bool success2=delp2.start();

    if (success && success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};

void knetfilter::delRule_tcp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }


    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(ip.length()==0 && netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address,\n"
				"and a netmask address.\n");
	else if(ip.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address.\n");
	else if(netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (dport.length()==0)
	    {
	      delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  delp << "iptables" << "-D" << chainChoice << "-p" << "tcp" << flagChoice << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }      
	}
    };

    bool success=delp.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::delRule_udp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, sport, dport, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.255");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    sport.sprintf((const char *)(addSourcePort->text()));
    dport.sprintf((const char *)(addDestinationPort->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));


    delp2.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp2 << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(sport.length()==0 && dport.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter a source or destination port number\n");
	else if(ip.length()==0 && netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address,\n"
				"and a netmask address.\n");
	else if(ip.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address.\n");
	else if(netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  if (dport.length()==0)
	    {
	      delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
	    }
	  else
	    {
	      if (sport.length()==0)	
		{
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice; 
		}
	      else
		{
		  delp2 << "iptables" << "-D" << chainChoice << "-p" << "udp" << "--sport" << sport << "--dport" << dport << "-s" << extranet << "-d" << network << "-j" << policyChoice;
		}
	    }      
	}
    };

    bool success2=delp2.start();

    if (success2)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::delRule_icmp() {

    QString ip, netmask, network, extramask, extranet, extranetwork, type, rulepos;

    /* Only for the purpose of checking the input data */
    ip.sprintf((const char *)(ipAddr->text()));
    netmask.sprintf((const char *)(netmaskAddr->text()));

    network.sprintf("%s/%s",(const char *)(ipAddr->text()), (const char *)(netmaskAddr->text()));

    extramask.sprintf((const char *)(extraNetMask->text()));
    if(extramask.length()==0)
      {
	extramask.sprintf("255.255.255.0");
      }

    extranetwork.sprintf((const char *)(extraNet->text()));
    rulepos.sprintf((const char *)(addRuleNumber->text()));

    extranet.sprintf("%s/%s",(const char *)(extraNet->text()), (const char*)(extramask));

    type.sprintf((const char *)(addIcmpType->text()));


    delp3.clearArguments();

    if(extranetwork.length()==0)
      {
	extranet.sprintf("0.0.0.0/0");
      }

    if((strcmp((const char*)(extraNet->text()),"0.0.0.0")==0))
    {
      extranet.sprintf("0.0.0.0/0");
    }

    if(rulepos.length()!=0)
      {
	delp3 << "iptables" << "-D" << chainChoice << rulepos;
      }
    else
      {
	if(type.length()==0) 
	  QMessageBox::critical(0, "Error",
				"You have to enter an icmp type number\n");
	else if(ip.length()==0 && netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address,\n"
				"and a netmask address.\n");
	else if(ip.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a IP address.\n");
	else if(netmask.length()==0)
	  QMessageBox::critical(0, "Error",
				"You have to supply a netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe") && !strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address and Netmask address.\n");
	else if(!strcmp(ip,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid IP address.\n");
	else if(!strcmp(netmask,"Couldn't probe"))
	  QMessageBox::critical(0, "Error",
				"Not a valid netmask address.\n");
	else {
	  delp3 << "iptables" << "-D" << chainChoice << "-p" << "icmp" << "--icmp-type" << type << "-s" << extranet << "-d" << network << "-j" << policyChoice;
	}
      };
	
    bool success=delp3.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

};


void knetfilter::stopAll() {

    stop.clearArguments(); 
    stop << "iptables" << "-F";
    bool success=stop.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};


void knetfilter::stopNAT() {

    stop_nat.clearArguments(); 
    stop_nat << "iptables" << "-t" << "nat" << "-F";
    bool success=stop_nat.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};

void knetfilter::stopMangle() {

    stop_mangle.clearArguments(); 
    stop_mangle << "iptables" << "-t" << "mangle" << "-F";
    bool success=stop_mangle.start();

    if (success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't flush iptables"), 2000);

};


void knetfilter::saveAll() {

  save.clearArguments();
  save << "kiptables-save";
  bool success=save.start();

  if (success)
    statusbar->message(i18n("Saving..."), 2000);
  else
    statusbar->message(i18n("Couldn't save iptables"), 2000);

};


void knetfilter::loadAll() {

  load.clearArguments();
  load << "kiptables-restore"; 
  bool success=load.start();

  if (success)
    statusbar->message(i18n("Saving..."), 2000);
  else
    statusbar->message(i18n("Couldn't save iptables"), 2000);

};



// log facilities
void knetfilter::addDone_tcp() {

  if (addp.normalExit() && (addp.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for tcp packets, source port %s, destination port %s, %s chain",policyChoice, (const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::addDone_udp() {

  if (addp2.normalExit() && (addp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for udp packets, source port %s, destination port %s, %s chain",policyChoice, (const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);

    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::addDone_icmp() {

  if (addp3.normalExit() && (addp3.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for icmp of type %s incoming, %s chain",policyChoice,(const char *)(addIcmpType->text()),chainChoice);
    messageLog->insertItem(msg);
    addIcmpType->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};


void knetfilter::delDone_tcp() {

  if (delp.normalExit() && (delp.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s for tcp packets, source port %s, destination port %s, %s chain, DELETED",policyChoice,(const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::delDone_udp() {

  if (delp2.normalExit() && (delp2.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s for udp packets, source port %s, destination port %s, %s chain,  DELETED",policyChoice,(const char *)(addSourcePort->text()),(const char *)(addDestinationPort->text()),chainChoice);
    messageLog->insertItem(msg);
    addSourcePort->clear();
    addDestinationPort->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addRuleNumber->setFocus();

};

void knetfilter::delDone_icmp() {

  if (delp3.normalExit() && (delp3.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleted"), 2000);
    QString msg;
    msg.sprintf("%s icmp of type %s incoming, %s chain, DELETED",policyChoice,(const char *)(addIcmpType->text()),chainChoice);
    messageLog->insertItem(msg);
    addIcmpType->clear();
    addRuleNumber->clear();
  } else
    statusbar->message(i18n("iptables died"), 2000);
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};


void knetfilter::saveDone() {

  if (save.normalExit() && (save.exitStatus()==0)) {
    statusbar->message(i18n("All rules saved"), 2000);
    messageLog->insertItem("Configuration Rules has been saved");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables-save died"), 2000);

};


void knetfilter::loadDone() {

  if (load.normalExit() && (load.exitStatus()==0)) {
    statusbar->message(i18n("All rules loaded"), 2000);
    messageLog->insertItem("Configuration Rules has been restored");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables-restore died"), 2000);

};


void knetfilter::stopDone() {

  if (stop.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All rules flushed"), 2000);
    messageLog->insertItem("All ports are now open");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};


void knetfilter::stop_natDone() {

  if (stop_nat.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All nat rules flushed"), 2000);
    messageLog->insertItem("All redirections are now flushed");
    addSourcePort->setFocus();
    addDestinationPort->setFocus();
    addIcmpType->setFocus();
    addRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};

void knetfilter::stop_mangleDone() {

  if (stop_mangle.normalExit() && (stop.exitStatus()==0)) {
    statusbar->message(i18n("All mangle rules flushed"), 2000);
    messageLog->insertItem("All magle rules are now flushed");
//    addmangleSourcePort->setFocus();
//    addmangleDestinationPort->setFocus();
//    addmangleIcmpType->setFocus();
//    addmangleRuleNumber->setFocus();
  } else
    statusbar->message(i18n("iptables died"), 2000);

};


// log cleaner
void knetfilter::clearLog() {

  messageLog->clear();
  addSourcePort->setFocus();
  addDestinationPort->setFocus();
  addIcmpType->setFocus();
  addRuleNumber->setFocus();

};
