/***************************************************************************
                          nodewidget.h  -  A simple netconfig tool
                             -------------------
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef NODEWIDGET_H
#define NODEWIDGET_H

#include <qwidget.h>

/**This class provides an element of the netmap. Each instance
represents a node on the network.
  *@author Federico David Sacerdoti
  */

class nodeWidget : public QWidget
{
	Q_OBJECT
public:
	//Widget Orientation
	enum compass { North = 1, East, South, West };

	nodeWidget(compass bearing=East, QWidget *parent=0, const char *name=0);
	~nodeWidget();
	
 	
public slots:
	/** Acitvates a node by Changing its color **/
	void ready();
	/** Sends out a link animation when the node is searching for a neighbor **/
	void find();
	/** Changes the link to a solid line and stops animation **/
	void found();
	/** Erases dots, puts an X in the link to say its broken **/
	void lost();
	/** Erases all marks in link **/
	void reset();

protected:
	virtual void timerEvent ( QTimerEvent *);
	virtual void paintEvent ( QPaintEvent *);
	void paintLink ( QPainter & );
	void paintNode ( QPainter & );
	QRect linkRect () const;
	QRect nodeRect () const;

protected:
	bool finding;
	int timerCount;
	int bearing;
	int linklength;
};


#endif












