/***************************************************************************
                          knarticlemanager.h  -  description
                             -------------------
    
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNARTICLEMANAGER_H
#define KNARTICLEMANAGER_H

#include <qobject.h>
#include <qtimer.h>
#include <qlistview.h>
#include "knreadheader.h"
#include "kngroupentry.h"
#include "knmessagefilter.h"


class KNArticleManager : public QObject {

 	Q_OBJECT

	public:
		KNArticleManager(QListView *v);
		~KNArticleManager();
		
		void readConfig();
				
		void setGroup(KNGroupEntry *g)	{ g_roup=g; if(!g) c_urrent=0; timer->stop();}
		KNGroupEntry* group()						{ return g_roup; }
		
		void showHdrs();
	  void expandAllHdrs(bool e);
	  void toggleThreaded()		{ g_roup->toggleThreaded(); showHdrs(); }
		bool threaded()					{ return g_roup->threaded(); }
	
	  bool setCurrentHdr(KNHeaderBase *h);
	  bool setCurrentHdr(const QString &mID);
	  KNReadHeader* currentHdr()	{ return c_urrent; }
	
	  void startTimer()						{ timer->start(tOut, true); }
		void stopTimer()						{ timer->stop(); }
	
	  void setCurrentHdrRead(bool r=true);		
	  void setCurrentThreadRead(bool r=true);
	  void setAllHdrsRead(bool r=true);
	  void setScoreOfThread();
	
	  KNMessageFilter* filter()		{ return f_ilter; }
	
	  	
	public slots:
		void slotFilterChanged(KNMessageFilter *f);
		
				
	protected:
		void setHdrRead(KNReadHeader *hdr, bool r=true);
		void createHdrItem(KNReadHeader *h);
		void createThread(KNReadHeader *h);
		
		KNGroupEntry* g_roup;
		KNReadHeader* c_urrent;
		KNMessageFilter *f_ilter;
		QTimer *timer;
		QListView *view;
		int tOut;
		
		
	protected slots:
		void slotTimeOut();
				
		
	
};

#endif











