/***************************************************************************
                          knfntcoloptions.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knfntcoloptions.h"
#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>


KNFntColOptions::KNFntColOptions(QWidget *parent, const char *name ) :
	KNOptionsWidget(parent,name)
{
	QGroupBox *cGrp=new QGroupBox(i18n("Colors"), this);
	QGroupBox *fGrp=new QGroupBox(i18n("Fonts"), this);
	
	cList=new QListBox(cGrp);
	colBtn=new KColorButton(cGrp);
	cList->setMinimumSize(200,100);
	colBtn->setMinimumSize(100,40);
	
	
	cList->insertItem(i18n("normal text"));
	cList->insertItem(i18n("links"));
	cList->insertItem(i18n("background"));
	cList->insertItem(i18n("foreground"));
	cList->insertItem(i18n("quoted text 1"));
	cList->insertItem(i18n("quoted text 2"));
	cList->insertItem(i18n("quoted text 3"));
	
	QLabel *l1=new QLabel(i18n("Family:"), fGrp);
	QLabel *l2=new QLabel(i18n("base size:"), fGrp);
	QLabel *l3=new QLabel(i18n("subject larger by:"), fGrp);
			
	fntFam=new QComboBox(false, fGrp);
	fntFam->setSizeLimit(10);
	QStrList *fLst=new QStrList;
	fLst->setAutoDelete(true);
	if(kapp->getKDEFonts(fLst)) fntFam->insertStrList(fLst);
	else {
		debug("ERROR: cannot get fontlist!");
		MBox(err, i18n("The kde-fontlist could not be loaded !\nPlease use the kde fontmanager to create it."));
		fntFam->insertItem("helvetica");
	}
	delete fLst;	
	
	fntBase=new QSpinBox(2,5,1, fGrp);
	fntSub=new QSpinBox(0,2,1, fGrp);
	
	fntComp=new QCheckBox(i18n("use this font in the composer"), fGrp);
	
	
	SIZE(l1); SIZE(l2); SIZE(l3);
	SIZE(fntFam); SIZE(fntBase); SIZE(fntSub); SIZE(fntComp);
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	QVBoxLayout *colL=new QVBoxLayout(cGrp, 20,10);
	QGridLayout *fntL=new QGridLayout(fGrp, 4,3, 20,10);
	
	colL->addWidget(cList, 1);
	colL->addWidget(colBtn);
	
	fntL->addWidget(l1, 0,0);
	fntL->addMultiCellWidget(fntFam, 0,0, 1,2);
	fntL->addWidget(l2, 1,0);
	fntL->addWidget(fntBase, 1,1);
	fntL->addWidget(l3, 2,0);
	fntL->addWidget(fntSub, 2,1);
	fntL->addMultiCellWidget(fntComp, 3,3, 0,2);
	
	fntL->setColStretch(2,1);
	
	topL->addWidget(cGrp,1);
	topL->addWidget(fGrp);
	
	topL->activate();
	
	
	connect(cList, SIGNAL(highlighted(int)), this, SLOT(slotCListChanged(int)));
	connect(colBtn, SIGNAL(changed(const QColor&)),
		this, SLOT(slotColorChanged(const QColor&)));
	
	readConfig();
  cList->setCurrentItem(0);
	
}



KNFntColOptions::~KNFntColOptions()
{
}



void KNFntColOptions::applyConfig()
{
	KConfig *c=CONF();
	char col[10];
	
	c->setGroup("FONTS-COLORS");
	
	for(int i=0; i<7; i++) {
		sprintf(col,"color%d", i+1);
		c->writeEntry(col, colors[i]);
	}
	
	c->writeEntry("family", fntFam->currentText());
	c->writeEntry("sizeBase", fntBase->value());
	c->writeEntry("sizeSubj", fntSub->value());
	c->writeEntry("composer", fntComp->isChecked());
	
}



void KNFntColOptions::readConfig()
{
	char col[10];
	KConfig *c=CONF();
	QColor w(white), b(black), g(gray);
	QColor *dflt;	
	
	c->setGroup("FONTS-COLORS");
	
	for(int i=0; i<7; i++) {
		sprintf(col,"color%d", i+1);
		
		if(i==2) dflt=&w;
		else if(i==3) dflt=&g;
		else dflt=&b;
		
		colors[i]=c->readColorEntry(col, dflt);
		
	}
	
	QString s=c->readEntry("family","helvetica");
	for(int i=0; i < fntFam->count(); i++)
		if(strcmp(fntFam->text(i), s.data())==0) {
			fntFam->setCurrentItem(i);
			break;
		}
	
	fntBase->setValue(c->readNumEntry("sizeBase", 3));
	fntSub->setValue(c->readNumEntry("sizeSubj", 1));
	fntComp->setChecked(c->readBoolEntry("composer", true));
	
	
}



void KNFntColOptions::slotCListChanged(int id)
{
	colBtn->setColor(colors[id]);
}



void KNFntColOptions::slotColorChanged(const QColor &col)
{
	int idx=cList->currentItem();
	if(idx!=-1) colors[idx]=col;
}










