/***************************************************************************
                          knfntcoloptions.h  -  description
                             -------------------
    
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNFNTCOLOPTIONS_H
#define KNFNTCOLOPTIONS_H


#include <knoptionswidget.h>
#include <qlistbox.h>
#include <kcolorbtn.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>


class KNFntColOptions : public KNOptionsWidget  {

  Q_OBJECT
	
	public:
		KNFntColOptions(QWidget *parent=0, const char *name=0);
		~KNFntColOptions();
		
		virtual void applyConfig();
		virtual void readConfig();
		
	protected:
		QListBox *cList;
		KColorButton *colBtn;
		
		QComboBox *fntFam;
		QSpinBox *fntBase, *fntSub;
		QCheckBox *fntComp;
		
		QColor colors[7];
		
	protected slots:
		void slotCListChanged(int id);
		void slotColorChanged(const QColor &col);
		
};

#endif





