/***************************************************************************
                     kngrmanager.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNGRMANAGER_H
#define KNGRMANAGER_H


#include <qlist.h>
#include <qlistview.h>
#include <qlistview.h>
#include "knntpclient.h"
#include "kngroupentry.h"
#include "knarticlemanager.h"



class KNGrManager {

	 			
	public:
		KNGrManager(KNArticleManager *a, QListView *v);
		~KNGrManager();
	 	
		void readConfig();
	 	void saveYourself();
	  void setAutoCheck(bool check) 	{ AutoCheck=check;}
		bool autoCheck() 								{ return AutoCheck;}
	 	
		
	  QStrList * activeList();
	  void subscribe(char *gName);
		bool unsubscribe(KNGroupEntry *en=0);
		void showListItems();
				
		bool setCurrent(KNEntryBase *_en);
		KNGroupEntry* current() 				{ return currGroup; } 	
				
		void expireCurrentNow();
				
		void showGroupDialog();
		bool Threaded();
				
		void checkAll();
	
			
	protected:
		int loadGroups();
		bool expireAll();
								
		QList<KNGroupEntry>  *GList;
		KNGroupEntry *currGroup;
		
		QStrList *actLst;
		KNArticleManager *aManager;
		QListView *view;
				
		int count;
		bool AutoCheck;

};



#endif






























































































