/***************************************************************************
                     knmessagecomp.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qlayout.h>

#include "knmessagecomp.h"
#include "utilities.h"
#include "kngroupselectdialog.h"
#include "knpostheader.h"
#include "knstringsplitter.h"


KNMessageComp::KNMessageComp(KNPostHeader *h) : QWidget(0,0)
{
	init();
	KConfig *c=CONF();
	c->setGroup("POSTNEWS");
	int ml=c->readNumEntry("maxLength", 78);
	edit->setFillColumnMode(ml, true);
	bool appSig=c->readBoolEntry("appSig", true);
	sigPos=1;
	
	c->setGroup("FONTS-COLORS");
	
	if(c->readBoolEntry("composer", true)) {
		QString fam=c->readEntry("family");
	
		if(!fam.isEmpty()) {
			QFont fnt=this->font();
			fnt.setFamily(fam);
			edit->setFont(fnt);
		}
	}
	
	groupList=new QStrList(true);
	groupList->setAutoDelete(true);
	
	result=del;
	hdr=h;
	
	if(!hdr->subject.isEmpty()) subj->setText(hdr->subject);
	else slotSubjectChanged("");
	
	
	if(hdr->sMode==KNPostHeader::Mail) {
	
		groupsL->setText(i18n("To:"));
	  if(!hdr->mailTo.isEmpty()) groupList->append(hdr->mailTo);
	  groups->setFocusPolicy(QWidget::StrongFocus);
	  	
	  enableFup->setEnabled(false);
	  groupsBtn->setEnabled(false);
	}
	
	else if(!hdr->groups.isEmpty()) {
		
		KNStringSplitter split;
		split.init(hdr->groups, ",");
	  if (split.first())
			do
				groupList->append(split.string());
			while(split.next());
	
		else groupList->append(hdr->groups);
	}
		
	updateGroups();	 	
					
	if(hdr->message)
		for(char *var=hdr->message->body()->first(); var;
		var=hdr->message->body()->next())
			edit->insertLine(var);
			
	edit->insertLine("");	
			
	if(appSig) {
		bool sigFound=false;
	
		for(int idx=0; idx<edit->numLines(); idx++) {
			sigFound=(strcmp(edit->textLine(idx), "-- ")==0);
			sigPos=idx;
			if(sigFound) break;
		}
		
		if(!sigFound) appendSig();
	}
	else sigPos=edit->numLines();
	
	edit->setCursorPosition(sigPos-1,0, false);
	
	
	edit->setFocus();
	setIcon(ICON("pen.xpm"));
	
	
}	



KNMessageComp::~KNMessageComp()
{
	delete groupList;
}



void KNMessageComp::closeEvent(QCloseEvent *e)
{
	if(result==unknown) {
		if(hasValidData()) result=save;
		else result=del;
	}
	
	emit composerDone(this);
}



void KNMessageComp::init()
{
	setMinimumSize(300,200);
	resize(600,500);
		
	tb=new KToolBar(this,0,32);
	tb->enableMoving(false);
	tb->enableFloating(false);
	tb->setMaxHeight(32);
			
	popUp=new QPopupMenu;
	popUp->insertItem(i18n("send &now"), BTN_SEND_NOW);
	popUp->insertItem(i18n("send &later"), BTN_SEND_LAT);
	
	tb->insertButton(ICON("send.xpm"), BTN_SEND_NOW, true, i18n("send"));
	tb->setDelayedPopup(BTN_SEND_NOW, popUp);
	tb->insertButton(ICON("save.xpm"), BTN_SAVE, true, i18n("save"));
	tb->insertButton(ICON("signature.xpm"), BTN_SIG, true, i18n("append signature"));
	tb->insertSeparator();
	tb->insertButton(ICON("delete.xpm"), BTN_DEL, true, i18n("delete"));
		
	
	inpFrame=new QFrame(this);
	inpFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	
	
	
	
	subj=new QLineEdit(inpFrame);
	subjL=initLabel(i18n("Subject:"));
	
	groups=new QLineEdit(inpFrame);
	groupsL=initLabel(i18n("Newsgroups:"));
	groups->setFocusPolicy(QWidget::NoFocus);
	groupsBtn=new QPushButton("...",inpFrame);
			
	fup=new QComboBox(true,inpFrame);
	fupL=initLabel(i18n("FollowUp-to:"));
	fup->setEnabled(false);
	enableFup=new QCheckBox(inpFrame);
	enableFup->setBackgroundColor(inpFrame->backgroundColor());
	enableFup->setAutoResize(true);
	
	edit=new KEdit(kapp,this);
	edit->setWordWrap(true);
		
	
		
	
	connect(groupsBtn, SIGNAL(clicked()), this, SLOT(slotGroupsBtn()));
	connect(subj, SIGNAL(textChanged(const char*)),
		this, SLOT(slotSubjectChanged(const char*)));
	connect(tb, SIGNAL(clicked(int)), this, SLOT(slotTBCallback(int)));
	connect(popUp, SIGNAL(activated(int)), this, SLOT(slotTBCallback(int)));
	connect(enableFup, SIGNAL(toggled(bool)), fup, SLOT(setEnabled(bool)));
		
}	



QLabel* KNMessageComp::initLabel(const char *text)
{
		QLabel *l=new QLabel(text, inpFrame);
		l->setBackgroundColor(inpFrame->backgroundColor());
		l->setAlignment(AlignVCenter | AlignRight);
		l->setAutoResize(true);
		return l;
}		



void KNMessageComp::resizeEvent(QResizeEvent *)
{
	updateRects();	
}



void KNMessageComp::updateRects()
{
	int max=subjL->width(), tbHeight=tb->height();
	
	if(groupsL->width()>max) max=groupsL->width();
	if(fupL->width()>max) max=fupL->width(); 	

	tb->updateRects(true);
	
	inpFrame->setGeometry(3,tbHeight+3,width()-6,110);
			
	subjL->move(5,8);
	subj->setGeometry(max+10,5,inpFrame->width()-max-20,25);
	
	groupsL->move(5,43);
	groups->setGeometry(max+10,40,inpFrame->width()-max-65,25);
	groupsBtn->setGeometry(max+groups->width()+25,40,30,25);
	
	fupL->move(5,78);
	fup->setGeometry(max+10,75,inpFrame->width()-max-65,25);
	enableFup->move(max+fup->width()+35,76);
			
	edit->setGeometry(3,tbHeight+inpFrame->height()+6,width()-6,
	height()-tbHeight-inpFrame->height()-6);
		
}



void KNMessageComp::updateGroups()
{
		
	if(!groupList->isEmpty())
		if(groupList->count()==1) {
			groups->setText(groupList->first());
			enableFup->setChecked(false);
			fup->clear();
		}
		
		else {
			
		  QString tmp(128);
			tmp=groupList->first();
			for(char *var=groupList->next(); var; var=groupList->next()) {
				tmp+=" , ";
				tmp+=var;
			}
			groups->setText(tmp);
			fup->insertStrList(groupList);
			enableFup->setChecked(true);
		}
	else {
		groups->clear();
		fup->clear();
		enableFup->setChecked(false);
	}	
	 	
}



void KNMessageComp::slotGroupsBtn()
{
	KNGroupSelectDialog *dlg=new KNGroupSelectDialog(this,0,groupList);
	
	if(dlg->exec()) {
		
	  dlg->applyResult();
	  updateGroups();				
		
	}
	
	
	delete dlg;
		
}



void KNMessageComp::slotTBCallback(int _id)
{
		
	switch(_id) {
		case BTN_SAVE : 		
			result=save;
			emit composerDone(this);
		break;	
		
		case BTN_SEND_NOW :
			result=send_now;
			emit composerDone(this);
		break;
		
		case BTN_SEND_LAT :	
			result=send_later;
			emit composerDone(this);
		break;
		
		case BTN_SIG:
			appendSig();
		break;
						
		case BTN_DEL :			
			result=del;
			emit composerDone(this);	
		break;
	}


}



void KNMessageComp::slotSubjectChanged(const char *t)
{
	if(strlen(t)>0) setCaption(t);
	else setCaption(i18n("new message"));
}



bool KNMessageComp::hasValidData()
{
	return ( (strlen(subj->text())>0) && (strlen(groups->text())>0) );
}



void KNMessageComp::setData()
{
	

	// body
	QStrList *b=hdr->message->body();
	b->clear();
	for(int idx=0; idx < edit->numLines(); idx++)
		b->append(edit->textLine(idx));
	
	//subject
	hdr->subject=subj->text();
	
	//get fup2
	if(enableFup->isChecked())
		hdr->fupTo=fup->currentText();
	else hdr->fupTo.resize(0);
	
	//get edited groups
	hdr->groups=groupList->first();
	for(char *var=groupList->next(); var; var=groupList->next()) {
		hdr->groups+=",";
		hdr->groups+=var;
	}
	
	//set lines as number of lines of the body
	hdr->lines=edit->numLines();
	
	//set time as current time
	hdr->setTime();

}



void KNMessageComp::appendSig()
{
	QString path=QDir::home().absPath()+"/.signature";
	QFile f(path);
	QTextStream ts(&f);
	
		
	if(f.exists()) {
		
	
		if(f.open(IO_ReadOnly)) {
			
			edit->insertLine("\n-- ");
			while(!f.atEnd())
				edit->insertLine(ts.readLine());
				
			f.close();
			
		}
		else MBox(ferr);
	}
	else MBox(inf, i18n("No signature file found\nin the home-directory."));
				
			
	
}












































































