/***************************************************************************
                          knmessagefilter.h  -  description
                             -------------------
    
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNMESSAGEFILTER_H
#define KNMESSAGEFILTER_H

#include <qstring.h>
#include <qdatetime.h>
#include <qbitarray.h>
#include "knreadheader.h"
#include "knreadheaderlist.h"
#include "knstatusfilter.h"
#include "knrangefilter.h"
#include "knstringfilter.h"


class KNMessageFilter {

	friend class KNFilterManager;
	friend class KNFilterDialog;

	public:
		KNMessageFilter();
		~KNMessageFilter();
		
		void loadInfo(KSimpleConfig &c);
		void load();
		void save();
								
		void doFilter(KNReadHeaderList &l);
		int count()											{ return mCount; }
		int id()												{ return mId; }
		const QString& name()						{ return mName; }
		bool isEnabled()								{ return mEnabled; }
		
	protected:
		
		enum ApOn { articles=0 , threads=1 };
		bool applyFilter(KNReadHeader *hdr);
		QString path();
			
		QString mName;
		int mId, mCount;
		bool mLoaded, mEnabled;
		ApOn apon;
		
		KNStatusFilter status;
		KNRangeFilter score, age, lines;
		KNStringFilter subject,from;
		
	
		
};

#endif










