/***************************************************************************
                     knmsgview.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNMSGVIEW_H
#define KNMSGVIEW_H

#include <qwidget.h>
#include <knhtml.h>
#include <qscrollbar.h>
#include <qstrlist.h>
#include <qstring.h>
#include "resource.h"
#include "knheaderbase.h"
#include "utilities.h"


class KNMsgView : public QWidget  {
	
  Q_OBJECT
	
	public:
		
		enum HeaderType{Short,Normal,All};
	
		KNMsgView(QWidget *parent=0, const char *name=0);
		~KNMsgView();
	
		void readConfig();
			
		void showBlankPage();
		void setHType(HeaderType t) 			{ hType=t;}
		HeaderType HType() 								{ return hType; }
		void showMsg(KNHeaderBase *hdr);
		void updateContents();
		void printContents() 							{ html->print(); }		
	
	public slots:
		void slotStatusMsg(const QString &msg);
		
			
	protected:
		KNHtml *html;
		QScrollBar *hScrollBar;
		QScrollBar *vScrollBar;
		void resizeEvent(QResizeEvent*);
		void keyPressEvent(QKeyEvent *e);
		
	
	protected slots:
		void slotOnURL(const char *url);
		void slotURLSelected(const char *_url, int btn);
		void slotDocChanged();
		void slotTextSelected(bool s);
		void slotClicked();
		
	private:
		QString toHtmlString(const char* line, bool parseURLs=true);
		bool isValidURLChar(char c);
				
		HeaderType hType;
		KNHeaderBase *current;
		bool showSig;
		QString hexColors[4];
		int sizeB, sizeS;
		
		
		
	signals:
		void mailTo(const char*);
		void referenceClicked(int);
};

#define FG_COL 	0
#define QCOL_1	  1
#define QCOL_2		2
#define QCOL_3		3

#endif














