/***************************************************************************
                     knodeview.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qheader.h>
#include <stdlib.h>
#include "knodeview.h"
#include "kngrmanager.h"
#include "knentryviewitem.h"
#include "knhdrviewitem.h"


KNodeView::KNodeView(KApplication* a, QWidget *parent)
	: KNewPanner(parent)
{
	
	PanHorz=new KNewPanner(this,0,KNewPanner::Horizontal);
	
	hdrView=new KNListView(PanHorz);
	entryView=new KNListView(this);
	
	msgView=new KNMsgView(PanHorz);
	
	PanHorz->activate(hdrView,msgView);
	activate(entryView,PanHorz);
	
	initEntryView();
	initHdrView();
	entryMenu=0;
	hdrMenu=0;
	
	setTabOrder(hdrView, msgView);
	setTabOrder(msgView, entryView);
	
}



KNodeView::~KNodeView()
{
}



void KNodeView::initEntryView()
{
 	entryView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
 	entryView->setAllColumnsShowFocus(true);
	entryView->addColumn(i18n("name"),150);
	entryView->addColumn(i18n("total"),50);
	entryView->addColumn(i18n("unread"),50);
	entryView->setColumnAlignment(1,AlignCenter);
	entryView->setColumnAlignment(2,AlignCenter);
	entryView->setSorting(0);
	entryView->header()->setClickEnabled(false);
	entryView->setColumnWidthMode(0,QListView::Maximum);
		
	connect(entryView, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint&, int)),
		this, SLOT(slotEMenu(QListViewItem *, const QPoint&, int)));
}



void KNodeView::initHdrView()
{
	hdrView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  hdrView->setAllColumnsShowFocus(true);
	hdrView->addColumn(i18n("Subject"),500);
	hdrView->addColumn(i18n("From"),300);
	hdrView->addColumn(i18n("Score"),50);
	hdrView->addColumn(i18n("Date (Time)"),300);
	hdrView->setRootIsDecorated(true);
	hdrView->setColumnAlignment(2, AlignCenter);
			
	connect(hdrView, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint&, int)),
		this, SLOT(slotHMenu(QListViewItem *, const QPoint&, int)));
}



int KNodeView::sepPos(int s)
{
	if(s==1) return this->separatorPos();
	else return PanHorz->separatorPos();
} 		
 		
 		
 		
void KNodeView::setSepPos(int s, int p)
{
	if(s==1) this->setSeparatorPos(p);
	else PanHorz->setSeparatorPos(p);
}
		


void KNodeView::headersSize(QStrList *lst)
{
	QHeader *h;
	char str[10];
	
	lst->clear();
	
	h=entryView->header();
	for(int i=0; i < 3; i++) {
		sprintf(str, "%d", h->cellSize(i));
		lst->append(str);
	}
	
	h=hdrView->header();
	for(int i=0; i < 4; i++) {
		sprintf(str, "%d", h->cellSize(i));
		lst->append(str);
	}
			
}


void KNodeView::setHeadersSize(QStrList *lst)
{
	QHeader *h;
  char *var=lst->first();
	
	h=entryView->header();
	for(int i=0; i<3; i++) {
		h->setCellSize(i, atoi(var));
		var=lst->next();
	}	
	
	h=hdrView->header();
	for(int i=0; i<4; i++) {
		h->setCellSize(i, atoi(var));
		var=lst->next();
		if(!var) break;
	}		
}



void KNodeView::nextHdr()
{
	QListViewItem *it=hdrView->currentItem();
	
	if(it) it=it->itemBelow();
	
	if(it) {
		hdrView->setSelected(it, true);
		hdrView->setCurrentItem(it);
		hdrView->ensureItemVisible(it);
	}
		
}



void KNodeView::prevHdr()
{
	QListViewItem *it=hdrView->currentItem();
	
	if(it) it=it->itemAbove();
	
	if(it) {
		hdrView->setSelected(it, true);
		hdrView->setCurrentItem(it);
		hdrView->ensureItemVisible(it);
	}
}
 		


void KNodeView::nextUnreadHdr()
{
	KNHdrViewItem *next, *current;
	KNReadHeader *hdr;
	
	current=(KNHdrViewItem*)hdrView->currentItem();
	if(!current) return;
	
	hdr=(KNReadHeader*)current->entry;
	
	if(hdr->hasUnreadSubs()) hdrView->setOpen(current, true);
	
	next=(KNHdrViewItem*)current->itemBelow();
	
	while(next) {
		hdr=(KNReadHeader*)next->entry;
		
		if(!hdr->isRead()) break;	
	  else {
	  	if(hdr->hasUnreadSubs()>0) hdrView->setOpen(next, true);
	  	next=(KNHdrViewItem*)next->itemBelow();
	  }
	
	}
	
	if(next) {
		hdrView->setSelected(next, true);
		hdrView->setCurrentItem(next);
		hdrView->ensureItemVisible(next);
	}
		
}



void KNodeView::nextUnreadThread()
{
	KNHdrViewItem *next, *current;
	KNReadHeader *hdr;
	
	current=(KNHdrViewItem*)hdrView->currentItem();
	if(!current) return;
	
	next=(KNHdrViewItem*)current->itemBelow();
	
	while(next) {
		hdr=(KNReadHeader*)next->entry;
			
		if(next->depth()==0) {
			if(!hdr->isRead() || hdr->hasUnreadSubs()) break;
		}
		next=(KNHdrViewItem*)next->itemBelow();
	}
	
	if(next) {
		
	  hdrView->setCurrentItem(next);
	
	  if(hdr->isRead()) nextUnreadHdr();
	  else {
			hdrView->setSelected(next, true);
		  hdrView->ensureItemVisible(next);
		}
		
	}
}




void KNodeView::slotHMenu(QListViewItem *it, const QPoint &p, int c)
{
	hdrView->setSelected(it,true);
	if(hdrMenu) hdrMenu->popup(p);
}



void KNodeView::slotEMenu(QListViewItem *it, const QPoint &p, int c)
{
	entryView->setSelected(it,true);
	if(entryMenu) entryMenu->popup(p);
}










