/***************************************************************************
                          kpopup.cpp  -  description
                          --------------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : henschel@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <malloc.h>

#include <kapp.h>

#include "make_popup.h"
#include "misc.h"
#include "kpopup.h"


Kpopup::Kpopup(int argc, char **argv, QWidget *parent, const char *name) : KTMainWindow (name)
{
 setMinimumSize(290, 260);
 setMaximumSize(290, 260);

 Init();
 InitToolbar();
 InitStatusbar();

 SetStatusText(i18n("Welcome to Kpopup " + QString(VERSION)));
 timer -> start(3000, TRUE);

 if(argc == 3)
   {
    Filename = (char *)malloc(((strlen(argv[1]) +1 ) * (sizeof(char))));
    sprintf(Filename, argv[1]);
    Filename[strlen(argv[1])] = 0;

    Sender = (char *)malloc(((strlen(argv[2]) + 1) * (sizeof(char))));
    sprintf(Sender, argv[2]);
    Sender[strlen(argv[2])] = 0;
   }
  else
   {
    Filename = (char *)malloc(1 * (sizeof(char)));
    Filename[0] = 0;
    Sender = (char *)malloc(1 * (sizeof(char)));
    Sender[0] = 0;
   }

 L_Label_Sender = new QLabel(i18n("Popup from:"), this);
 L_Label_Sender -> setGeometry(22, 38, 98, 20);
 L_Label_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Sender = new QLabel(Sender, this);
 L_Sender -> setGeometry(100, 35, 170, 20);
 L_Sender -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Label_DateTime = new QLabel(i18n("Popup time:"), this);
 L_Label_DateTime -> setGeometry(22, 63, 98, 20);
 L_Label_DateTime -> setAlignment(AlignTop | AlignLeft);

 if(strlen(Filename) != 0)
   {
    L_PopupText = new QLabel(File_read(Filename, 41), this);

    Time = new QTime();
    *Time = Time -> currentTime();
    Date = new QDate();
    *Date = Date -> currentDate();
    L_DateTime = new QLabel(Date -> toString() + "  " + Time -> toString(), this);
   }
  else
   {
    L_PopupText = new QLabel("", this);

    L_DateTime = new QLabel("", this);
   }

 L_DateTime -> setGeometry(100, 60, 170, 20);
 L_DateTime -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_DateTime -> setAlignment(AlignTop | AlignLeft);

 L_PopupText -> setGeometry(20, 85, 250, 150);
 L_PopupText -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_PopupText -> setAlignment(AlignTop | AlignLeft);
}


Kpopup::~Kpopup()
{
}


void Kpopup::Init()
{
 timer = new QTimer(this);
 connect(timer, SIGNAL(timeout()), this, SLOT(timerDone()));
}

void Kpopup::InitToolbar()
{
 toolbar = new KToolBar(this);
 loader = kapp -> getIconLoader();

 toolbar -> insertButton(loader -> loadMiniIcon("exit.xpm"), ID_EXIT, TRUE, i18n("Quit"));
 toolbar -> insertSeparator();
 toolbar -> insertButton(loader -> loadMiniIcon("filenew.xpm"), ID_NEW_POPUP, TRUE, i18n("New Popup"));
 toolbar -> insertButton(loader -> loadMiniIcon("reload.xpm"), ID_ANSWER_POPUP, TRUE, i18n("Answer Popup"));
 toolbar -> insertSeparator();
 toolbar -> insertSeparator();
 toolbar -> insertButton(loader -> loadMiniIcon("help.xpm"), ID_HELP, TRUE, i18n("Help"));

 connect(toolbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));

 toolbar -> show();
 addToolBar(toolbar);
 toolbar -> setBarPos(KToolBar::Top);
}


void Kpopup::InitStatusbar()
{
 statusbar = new KStatusBar(this);

 statusbar -> insertItem("", ID_STATUS_TEXT);
 statusbar -> show();
 setStatusBar(statusbar);
}


void Kpopup::AnswerPopup()
{
 if(strlen(Sender) != 0)
   {
    make_Popup *AnswerPopupView;

    AnswerPopupView = new make_Popup(this, "Blabla");
    AnswerPopupView -> resize(280, 220);
    AnswerPopupView -> setCaption(i18n("Answer Popup"));
    AnswerPopupView -> CB_Receiver -> insertItem(Sender, -1);
    AnswerPopupView -> ReadBrowseList();
    AnswerPopupView -> CB_Receiver -> setCurrentItem(0);
    AnswerPopupView -> exec();
   }
  else
   {
    make_Popup *NewPopupView;

    NewPopupView = new make_Popup(this, "Blabla");
    NewPopupView -> resize(280, 220);
    NewPopupView -> setCaption(i18n("New Popup"));
    NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
    NewPopupView -> ReadBrowseList();
    NewPopupView -> CB_Receiver -> setCurrentItem(0);
    NewPopupView -> exec();
   }
}


void Kpopup::NewPopup()
{
 make_Popup *NewPopupView;

 NewPopupView = new make_Popup(this, "Blabla");
 NewPopupView -> resize(280, 220);
 NewPopupView -> setCaption(i18n("New Popup"));
 NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
 NewPopupView -> ReadBrowseList();
 NewPopupView -> CB_Receiver -> setCurrentItem(0);
 NewPopupView -> exec();
}


void Kpopup::commandCallback(int id_)
{
 switch(id_)
  {
   case ID_EXIT:
                kapp -> quit();
                break;
   case ID_NEW_POPUP:
                     NewPopup();
                     break;
   case ID_ANSWER_POPUP:
                        AnswerPopup();
                        break;
   case ID_HELP:
								kapp -> invokeHTMLHelp("", "");
                break;		
  }
}

void Kpopup::timerDone()
{
 statusbar -> changeItem("", ID_STATUS_TEXT);
}


void Kpopup::SetStatusText(const char *text)
{
 statusbar -> changeItem(text, ID_STATUS_TEXT);
}