//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#ifndef NNTP_H
#define NNTP_H


#include <mimelib/mimepp.h>
#include <qdict.h>
#include <qobject.h>

#include "artcontainers.h"

class KSocket;
class NNTP;
class QStrList;
class KMMessage;
class KSimpleConfig;
class Artdlg;

#define PART_NONE 0
#define PART_HEAD 1
#define PART_BODY 2
#define PART_ALL (PART_HEAD | PART_BODY)

enum MessageParts {Nopart=PART_NONE,Head=PART_HEAD,Body=PART_BODY,All=PART_ALL};

class NewsGroup
{
public:
    NewsGroup(const char *name);
    ~NewsGroup();
    void save();
    void load();

    int lastArticle(NNTP &server);
    void saveLastArticle(NNTP &server,int i);
    
    //A pointer to the article window, or 0.
    //used to be boolean, that's why the name is weird.
    Artdlg *isVisible;
    //List of articles in the newsgroup.
    ArticleList artList;
    void getList(const char *extracond=0);
    void updateList();
    void getSubjects(NNTP &server);
    void getMessages(NNTP &server);
    void getTaggedMessages(NNTP &server);
    void catchup();
    QString genQuery();
    int countNew(NNTP &server);
    char *name;
    bool dirty;
private:
    KSimpleConfig *sconf;
};

typedef QListT<NewsGroup> GroupListBase;

class GroupList: public GroupListBase
{
public:
    GroupList();
    ~GroupList();
protected:
    virtual int compareItems(GCI item1,GCI item2);
};





class NNTP: public QObject, public DwNntpClient
{
    
    Q_OBJECT
        
public:
    NNTP(char *hostname=0);
    ~NNTP();
    
    bool    connect();
    bool    disconnect();
    bool    isConnected() {return Connected;};
    bool    isReadOnly() {return Readonly;};
    void    groupList(bool fromserver);
    bool    setGroup( const char *groupname);
    char    *group() {return GroupName.data();};
    bool    artList(int from=0,int to=0,NewsGroup *n=0);
    bool    getMissingParts(MessageParts parts,const char *id);
    void    article(const char *id, QString &data);
    void    head(const char *id, QString &data);
    void    body(const char *id, QString &data);
    static MessageParts isCached(const char *id);
    int     authinfo(const char *username,const char *password);
    int     setMode (char *mode);
    QString    	hostname;
    int     first;
    int     last;
    int     howmany;
    char    *lastStatusResponse() { return Laststatus.data();};
    void    resetCounters( bool byte=true,bool command=true);
    void    reportCounters (bool byte=true,bool command=true);
    long     byteCounter;
    long     oldbytes;
    int     commandCounter;
signals:
    void newStatus(const char *status);
    void lostServer();

public slots:
    void refresh();
    
private:
    bool checkDisconnection();
    bool    reportBytes;
    bool    reportCommands;
    int         listOverview();
    int         listXover(int from=0,int to=0,NewsGroup *n=0);
    
    QString 	Laststatus;
    QString 	GroupName;
    bool    	Connected;
    bool       	Readonly;
    bool       	connected;
    void       	overviewFmt( QString of );
    int		OffsetArticleNumber;
    int		OffsetSubject;
    int		OffsetFrom;
    int		OffsetLines;
    int         OffsetID;
    int		OffsetDate;
    int         OffsetRef;
    int         OffsetXRef;
    DwString     partialResponse;
    void        PGetTextResponse();
    static QString saneID(const char *id);
};


#endif
