#ifndef ARTICLE_H
#define ARTICLE_H

#include "rules.h"
#include "gigabase/gigabase.h"
class QListViewItem;
class QListView;
class KMMessage;


class Article;

class group
{
public:
    group() {name =new char[1];};
    char *name;
    dbArray < dbReference <Article> >articles;
    CLASS_DESCRIPTOR (group,(
                             FIELD(name),
                             RELATION (articles,groups)));
};

class Article
{
public:
    Article ();
    Article (const char *ID);
    Article (Article *art);
    ~Article ();
    char *desperate;
    char *Subject;
    int8 Lines;
    char *From;
    char *ID;
    dbDateTime Date;
    char *Ref;
//    static bool isRead(const char *ID);
    void setRead(bool b=true,bool commit=true);
    bool isAvailable() {return isavail;};
    void setAvailable(bool b=true);
    void setMarked(bool b=true,bool commit=true) ;
    bool isMarked(){return ismarked;};
    void save(bool commit=true);
    bool load();
    bool cached();
    int  score();
    void lookupAltavista();
    KMMessage *createMessage();
    QListViewItem *item(QListView *list);
    QListViewItem *item(QListViewItem *list);
    bool canExpire();
    void setExpire(bool b,bool commit=true);
    void toggleExpire(bool commit=true);

    dbArray < dbReference <group> > groups;

    dbArray <int> lists;

    bool isread;
    bool isavail;
    bool ismarked;
    bool expire;  // robert's cache stuff
    CLASS_DESCRIPTOR (Article,(
                               KEY(ID,INDEXED|HASHED),
                               FIELD(From),
                               FIELD(Subject),
                               FIELD(Date),
                               FIELD(Ref),
                               FIELD(desperate),
                               FIELD(expire),
                               FIELD(ismarked),
                               FIELD(isread),
                               FIELD(Lines),
                               FIELD(lists),
                               RELATION (groups,articles),
                               DBMETHOD (score),
                               DBMETHOD (cached)
                              ));
};

#endif