#include "artlist.h"
#include "articleitem.h"
#include "article.h"

#include <kapp.h>
#include <klocale.h>

extern bool strictdelete;

int uniqueArtListID=0;
ArtList *array[256];


ArtList *ArtList::getArtListByID(int id)
{
    if (id<255)
        return array[id];
    return 0;
}


ArtList::ArtList(QWidget *parent) :QListView (parent)
{
    uniqueArtListID++;
    ID=uniqueArtListID;
    array[ID]=this;
    debug ("New artlist with ID=%d",ID);
    addColumn(klocale->translate("Subject"), 150);
    setColumnWidthMode(0,QListView::Manual);
    addColumn(klocale->translate("Date"), 75);
    setColumnWidthMode(1,QListView::Manual);
    addColumn(klocale->translate("Lines"), 50);
    setColumnWidthMode(2,QListView::Manual);
    addColumn(klocale->translate("Score"), 50);
    setColumnWidthMode(3,QListView::Manual);
    addColumn(klocale->translate("Status"), 50);
    setColumnWidthMode(4,QListView::Manual);
    addColumn( klocale->translate("Sender"), -1);
    setAllColumnsShowFocus (true);
    connect (this,SIGNAL(doubleClicked(QListViewItem *)),
             this,SLOT(slotDoubleClicked(QListViewItem *)));
    connect (this,SIGNAL(selectionChanged(QListViewItem *)),
             this,SLOT(slotSelectionChanged(QListViewItem *)));
    connect (this,SIGNAL(returnPressed(QListViewItem *)),
             this,SLOT(slotReturnPressed(QListViewItem *)));
    connect (this,SIGNAL(rightButtonClicked(QListViewItem *,const QPoint &,int)),
             this,SLOT(slotRightButtonClicked(QListViewItem *)));
}
void ArtList::slotSelectionChanged(QListViewItem *item)
{
    debug ("left click detected");
    ArticleItem *i=(ArticleItem *)item;
    if (!i->ID.isEmpty())
    {
        jumpToID(i->ID.data());
        emit leftClick(i->ID.data());
    }
}
void ArtList::slotDoubleClicked(QListViewItem *item)
{
    debug ("double click detected");
    ArticleItem *i=(ArticleItem *)item;
    if (!i->ID.isEmpty())
    {
        emit doubleClick(i->ID.data());
        i->update();
    }
}
void ArtList::slotReturnPressed(QListViewItem *)
{
    debug ("return detected");
}
void ArtList::slotRightButtonClicked(QListViewItem *item)
{
    debug ("right click detected");
    ArticleItem *i=(ArticleItem *)item;
    if (!i->ID.isEmpty())
    {
        emit rightClick(i->ID.data());
        i->update();
    }
}

ArticleItem *ArtList::nextItem(ArticleItem *_item)
{
    QListViewItem *item=_item;
    if (item) //one item is given
    {
        //if it has childs, the first child
        if (item->childCount())
        {
            //necessary or items will not be sorted
            item->setOpen(true);
            item=item->firstChild();
        }
        else //Go for next sibling
        {
            if (item->nextSibling()) //has a next sibling
            {
                item=item->nextSibling(); //return the sibling
            }
            else
            {
                while (item->parent()) //Go for parent's sibling
                {
                    item=item->parent();
                    if (item->nextSibling()) //if parent really had a sibling
                    {
                        item=item->nextSibling(); //return the sibling
                        break;
                    }
                }
            }
        }
    }
    return (ArticleItem *)item;
}

ArticleItem *ArtList::prevItem(ArticleItem *item)
{
    if (item)
        return (ArticleItem *)(item->itemAbove());
    else
        return 0;
}

void ArtList::clear()
{
    debug ("clearing article list ID=%d",ID);
    //Tell all articles that are marked as visible here, that they are not.
    QString s;
    s.sprintf ("exists i: (lists[i]=%d)",ID);
    dbCursor <Article> *cursor=new dbCursor <Article>;
    dbQuery q(s.data());
    if (cursor->select(q))
    {
        debug ("removing reference to the list from %d articles",(*cursor).getNumberOfRecords());
        Article *art=cursor->first();
        while (art)
        {
            for (unsigned int i=0;i<art->lists.length();i++)
            {
                if (art->lists[i]==ID)
                {
                    art->lists.remove(i);
                    art->save(false);
                    break;
                }
            }
            art=cursor->next();
        }
    }
    cursor->reset();
    strictdelete=false;
    delete cursor;
    strictdelete=true;
    items.clear();

    QListView::clear();
}

void ArtList::updateByID(const char *ID)
{
    if (ID)
    {
        ArticleItem *i=items.find(ID);
        if (i)
            i->update();
    }
}

void ArtList::jumpToID(const char *ID)
{
    if (ID)
    {
        ArticleItem *item=items.find(ID);
        if (item)
        {
            setCurrentItem(item);
            setSelected(item,true);
            ensureItemVisible(item);
            item=(ArticleItem *)(item->parent());
            while (item)
            {
                item->setOpen(true);
                item=(ArticleItem *)(item->parent());
            }
        }
    }
}