/* This file is part of the KDE libraries
    Copyright (C) 1999 Corel Corporation
  		 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KPWDBOX
#define KPWDBOX 1

#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qsize.h>

class KPasswordEdit : public QLineEdit
{
public:
	KPasswordEdit ( QWidget * parent=0, const char * name=0 );
  
	// fixes the password security issue (could cut/paste to editor)
	void leaveEvent(QEvent *) {}
  void focusOutEvent(QFocusEvent*);
};

class KPwdBox : public QDialog
{
   Q_OBJECT
public:
	KPwdBox(QWidget *, const char *, bool, WFlags);
	~KPwdBox() {};
	void		setMessage(const char * msg);
	int 		exec();

protected:
	void 		resize(int, int);
	void		resize(QSize);
	QSize		sizeHint();

private:
	QLineEdit	* 	pwdBox;
	QLabel *	msg;
	QWidget	*	m_pParent;

	QPushButton *	ok;
	QPushButton *	cancel;
	
	// private methods
	void		setLocalGeometry();
};
#endif
