#include "mymaintable.h"
#include "mymaintable.moc"
//#include "main.h"
#include <qstring.h>
#include <qcursor.h>

#include <kapp.h>
#include <kiconloader.h>

/*-------------------------------------------------------------------
	List of the current available B-Channels per ISDN-Card
	Status 			-"-
-------------------------------------------------------------------*/
MyMainTable::MyMainTable (QWidget *parent, const char * name) 
	: KTabListBox (parent, name)
{
	setNumCols(3);
	setSeparator('\t');
	setColumn(0, i18n("Name"), 120, MixedColumn);
	setColumn(1, i18n("Path"), 200);
	setColumn(2, i18n("Comment"), 400);
	
	right_mouse_button = new QPopupMenu;
	right_mouse_button->insertItem ( i18n("Edit Service..."),
				  this, 	SLOT(edit_service_from_outside()) );
	right_mouse_button->insertItem ( i18n("Toggle status"),
				  this, 	SLOT(toggleStatus()));
	right_mouse_button->insertItem ( i18n("Remove Service"),
				  this, 	SLOT(deleteService()));

	connect ( this, SIGNAL(highlighted(int,int)), SLOT(save_position(int,int)) );
	connect ( this, SIGNAL(selected(int,int)), SLOT(edit_service(int,int)) );
	connect ( this, SIGNAL(popupMenu(int,int)), SLOT(ShowMenu(int,int)) );
}

void MyMainTable::deleteService()
{
	daten->deleteService(save_Row);
	SetListValues(daten);
}

/*---------------------------------------------------------
	check type of service and call the right editwindow
---------------------------------------------------------*/
void MyMainTable::edit_service(int index,int)
{

	servicedaten = daten->getServiceDataPointer(index);

// Check type of service

	if ( (strcasecmp(servicedaten->find("service type"),"fileservice") == 0) )
	{
		myservicewidget ServiceWidget; 
		ServiceWidget.setData(daten->getServiceDataPointer(index));
		if ( ServiceWidget.exec() ) 
		{
			ServiceWidget.saveData(daten->getServiceDataPointer(index));
			SetListValues(daten);
		}
	}

	else
	{
		myprinterwidget PrinterWidget; 
		PrinterWidget.setData(daten->getServiceDataPointer(index));
		if ( PrinterWidget.exec() ) 
		{
			PrinterWidget.saveData(daten->getServiceDataPointer(index));
			SetListValues(daten);
		}
	}
}

void MyMainTable::edit_service_from_outside()
{
	edit_service(currentItem(),0);
}

int MyMainTable::getCurrentItem()
{
	return save_Row;
}

void MyMainTable::resizeEvent (QResizeEvent* _event)
{
	QSize _Size;

	_Size = _event->size();
	setColumnWidth(2,_Size.width()-120-200-4);	//-4 because the bottom-scrollbar

	KTabListBox::resizeEvent(_event);
}

void MyMainTable::save_position(int _Row, int _Column)
{
	save_Row = _Row;
	save_Column= _Column;
}

void MyMainTable::SetListValues(datenclass *_daten)
{
	static QPixmap 	AktivePrintServicePix, 
			InAktivePrintServicePix,
			AktiveFileServicePix, 
			InAktiveFileServicePix;
	int index = 0;
	int _currentItem;
	QString tempstring;

	daten = _daten;
	services_list = daten->services_list;
	
	KIconLoader* loader = kapp->getIconLoader();
	AktivePrintServicePix = loader->loadIcon("printer.xpm");
	InAktivePrintServicePix = loader->loadIcon("printer_inactive.xpm");
	AktiveFileServicePix = loader->loadIcon("folder.xpm");
	InAktiveFileServicePix = loader->loadIcon("folder_inactive.xpm");
	dict().insert("AktivePrintServicePix", &AktivePrintServicePix);
	dict().insert("InAktivePrintServicePix", &InAktivePrintServicePix);
	dict().insert("AktiveFileServicePix", &AktiveFileServicePix);
	dict().insert("InAktiveFileServicePix", &InAktiveFileServicePix);

	setAutoUpdate(false);

	_currentItem = currentItem();

	clear();				//delete old values

	for (services_list.first(); services_list.current(); services_list.next() )
	{
		servicedaten = daten->getServiceDataPointer(index);
		if ( (strcasecmp(servicedaten->find("service type"),"printservice") == 0))
		{
			if ( (strcasecmp(servicedaten->find("available"),"yes") == 0))
 			tempstring = "{AktivePrintServicePix}";
			else
			tempstring = "{InAktivePrintServicePix}";
		}
		else
		{
			if ( (strcasecmp(servicedaten->find("available"),"yes") == 0))
			{
				tempstring = "{AktiveFileServicePix}";
			}
			else
			{
				tempstring = "{InAktiveFileServicePix}";
			}
		}
		tempstring.append(servicedaten->find("service name"));
		tempstring.append("\t");
		if ((strcasecmp(servicedaten->find("path"),"") == 0))	//path is empty (homes)
		tempstring.append(" ");
		else
		tempstring.append(servicedaten->find("path"));
		tempstring.append("\t");
		if ((strcasecmp(servicedaten->find("comment"),"") == 0))	//comment is empty
		tempstring.append(" ");
		else
		tempstring.append(servicedaten->find("comment"));
		insertItem(tempstring.data());
		index++;
	}
//	printf("currentItem= %d \n",_currentItem);
//	if (_currentItem == -1 || _currentItem < numRows()) 
		setCurrentItem(0);
//		else
//		setCurrentItem(_currentItem);
	setAutoUpdate(true);
	repaint();
}

void MyMainTable::ShowMenu(int _Row, int)
{
	setCurrentItem(_Row);
	right_mouse_button->popup(QCursor::pos());
}

void MyMainTable::toggleStatus()
{
	servicedaten = daten->getServiceDataPointer(currentItem());

	if ( (strcasecmp(servicedaten->find("available"),"yes") == 0))
	servicedaten->replace("available","no");
	else
	servicedaten->replace("available","yes");

	SetListValues(daten);
}

MyMainTable::~MyMainTable()
{
}
