/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* mainlistbox.cpp */

#include "mainlistbox.h"
#include "mainlistbox.moc"

MainListBox::MainListBox( QWidget* parent, const char* name, WFlags f )
    : QListBox( parent, name, f )
{

}

void MainListBox::mousePressEvent( QMouseEvent* pMouse )
{
    if( RightButton == pMouse->button() )
    {
	QPoint* pPoint = new QPoint( pMouse->x(), pMouse->y() );
	emit RightMouse( *pPoint );
    }
}		 

void MainListBox::paintCell(QPainter *p, int row, int col)
{
    QListBox::paintCell( p, row, col );
}   

//----------------------------------------------------------------------------

void MyListBoxItem::paint( QPainter *p )
{
    p->setPen( m_color );
     
    QColor old_background = p->backgroundColor();
   
    if( black == p->backgroundColor() )
    {
	p->setBackgroundMode( OpaqueMode );
	p->setBackgroundColor( yellow );
	p->eraseRect( p->window() );
    }
   
    p->drawPixmap( 3, 0, pm );
    QFontMetrics fm = p->fontMetrics();
    int yPos;                       // vertical text position
			       
    if ( pm.height() < fm.height() )
	yPos = fm.ascent() + fm.leading()/2;
    else
	yPos = pm.height()/2 - fm.height()/2 + fm.ascent();
					    
    p->drawText( pm.width() + 5, yPos, text() );
   
    p->setBackgroundMode( TransparentMode );
    p->setBackgroundColor( old_background );
}
	
int MyListBoxItem::height(const QListBox *lb ) const
{ 
    return QMAX( pm.height(), lb->fontMetrics().lineSpacing() + 1 );
}    

int MyListBoxItem::width(const QListBox *lb ) const
{
    return pm.width() + lb->fontMetrics().width( text() ) + 6;
}

