/*
   $Id: contact.cc,v 2.25.4.2.2.1 1998/12/18 18:22:21 herwinjs Exp $
 
   ***************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * contact.cpp                                                             *
   * Handles the contact list                                                *
   **************************************************************************/


#include "contact.h"
#include "packets.h"
#include "net.h"

CONTACT contactList[ MAXCONTACT ];
int contactNum;
char RcontactPath[ BUFSIZE ];
extern USER_CONFIGURATION user_config;
extern CALLBACK_FUNCTIONS callback;

int contact2Uin[ 100 ];
/*
   ** 
   ** Reads the contact list from a file
   ** Returns 0 of the contact file was found and -1 if not
*/
int contact_init( char *contactPath )
{
	if ( user_config.awaymsg )
		free( user_config.awaymsg );
	user_config.awaymsg = ( char * ) malloc( BUFSIZE );
	strcpy( RcontactPath, contactPath );
	ifstream contactFile( contactPath, ios::in );
	if ( !contactFile )
	{
		char tmp[ BUFSIZE ];
		sprintf( tmp, "Couldn't open %s.", contactPath );
		misc_log( tmp );

		contactNum = 0;

		return - 1;
	}
	else
	{
		contactNum = -1;
                char *string;
                string=(char *)malloc(BUFSIZE);
		//char *string2;
		char *tmp;
		while ( contactFile.getline( string, BUFSIZE ) )
		{
			contactNum++;

			contactList[ contactNum ].status = STATUS_OFFLINE;

			//string2 = string;
			//string2 = strdup(string);

                        tmp = strtok( string, ":");
                        
                        
			//tmp = strsep( &string2, ":" );
			contactList[ contactNum ].uin = atoi( tmp );

                        tmp = strtok( NULL, "" );
			//tmp = strsep( &string2, ":" );
			if (tmp!=NULL) 
			{
			    strcpy( contactList[ contactNum ].nick, tmp );
			    if ( strlen( tmp ) <= 0 || tmp[ 0 ] == '\n' || tmp[ 0 ] == '\r' )
			    {
				contactList[ contactNum ].nick[ 0 ] = 0;
			    }
			}
			else 
			{
			    contactList[ contactNum ].nick[ 0 ] = 0;
			}
			//tmp = strsep( &string2, ":" );
			//if ( !tmp )
			contactList[ contactNum ].ip = inet_addr( "0.0.0.0" );

			//tmp = strsep( &string2, "" );
			//if ( !tmp )

                        contactList[ contactNum ].real_ip = inet_addr( "0.0.0.0" );

			contactList[ contactNum ].port = 0;
			contactList[ contactNum ].sock = -1;
			contactList[ contactNum ].chatsock = -1;
			contactList[ contactNum ].len = 0;
			contactList[ contactNum ].data = NULL;
			contactList[ contactNum ].rpacket = NULL;
			contactList[ contactNum ].awaymsg = NULL;
			contactList[ contactNum ].chatport = 0;
			contactList[ contactNum ].active = 0;
			contactList[ contactNum ].clas = NULL;
			if ( contactList[ contactNum ].uin == 0 )
				contactNum--;

                }
                free( string );
		return 0;
	}
}
int contact_save( char *contactPath )
{
	FILE * cf = fopen( contactPath, "w" );
	char tmp[ BUFSIZE ];
	for ( int i = 0; i <= contactNum; i++ )
	{
		sprintf( tmp, "%d:%s\n", contactList[ i ].uin, contactList[ i ].nick );
		fwrite( tmp, ( streamsize ) strlen( tmp ), 1, cf );
	}
	fclose( cf );
	return 1;
}

int contact_add( const char *nick, UIN uin )
{
	if ( uin > 0 )
	{
		contactNum++;
		contactList[ contactNum ].status = STATUS_OFFLINE;
		contactList[ contactNum ].sock = -1;
		contactList[ contactNum ].chatsock = -1;
		contactList[ contactNum ].uin = uin;
		strcpy( contactList[ contactNum ].nick, nick );
		contactList[ contactNum ].ip = inet_addr( "0.0.0.0" );
		contactList[ contactNum ].real_ip = inet_addr( "0.0.0.0" );
		contactList[ contactNum ].awaymsg = NULL;
		contactList[ contactNum ].port = 0;
		contactList[ contactNum ].len = 0;
		contactList[ contactNum ].active = 0;

		contactList[ contactNum ].data = NULL;
		contactList[ contactNum ].rpacket = NULL;
		contactList[ contactNum ].chatport = 0;
		contactList[ contactNum ].clas = NULL;

		FILE *cf = fopen( RcontactPath, "a+" );
		char tmp[ BUFSIZE ];
		sprintf( tmp, "%d:%s\n", uin, nick );
		fwrite( tmp, ( streamsize ) strlen( tmp ), 1, cf );
		fclose( cf );

		ICQ_PACKET packet;
		packet = packets_add_user2list( uin );
		net_udpSend( packet.data, packet.length );
		( *callback.addnewUser ) ( uin );
		( *callback.updateContact ) ( uin );

		if ( ( UIN ) atoi( nick ) == uin )
		{
			for ( int t = 0; t < 10; t++ )
			{
				if ( contact2Uin[ t ] == 0 )
				{
					contact2Uin[ t ] = ( int ) send_infoReply( uin );
					return contactNum;
				}
			}
		}
		return contactNum;
	}
	else
		return 1;
}

/*
   ** 
   ** Return the number of entries in the contactList
*/
int contact_length()
{
	return contactNum + 1;
}


/*
   ** 
   ** Returns an entry in the contact list, or an entry with uin 0 on
   ** error
*/
CONTACT contact_returnItemNum( int num )
                      {
                  	if ( num <= contactNum )
                      		return contactList[ num ];
                  	else
                      	{
                      		CONTACT contact;
                      		contact.uin = 0;

                      		return contact;
                      	}
                      }


                      /*
                         ** 
                         ** Convert uin to nick
                      */
                      char *contact_uin2nick( unsigned int uin )
                      {
                  	for ( int i = 0; i <= contactNum; i++ )
                      	{
                  		if ( uin == contactList[ i ].uin )
                      			return contactList[ i ].nick;
                      	}
                      	//char tmp[12];
                      	char *tmp;
                      	tmp = ( char * ) malloc( 12 );
                      	sprintf( tmp, "%d", uin );
                      	return tmp;
                      }
                      int contact_isuin( unsigned int uin )
                      {
                  	for ( int i = 0; i <= contactNum; i++ )
                      	{
                  		if ( uin == contactList[ i ].uin )
                      			return 1;
                      	}
                      	return 0;
                      }


                      /*
                         ** 
                         ** Convert nick to uin
                      */
                      unsigned int contact_nick2uin( char *nick )
                      {
                  	for ( int i = 0; i <= contactNum; i++ )
                      	{
                  		if ( !strcasecmp( nick, contactList[ i ].nick ) )
                      			return contactList[ i ].uin;
                      	}

                      	return( atoi( nick ) );
                      }


                      /*
                         ** 
                         ** Return entry which match uin, or entry with uin 0 on error
                      */
                      CONTACT contact_returnContact( unsigned int uin )
                                            {
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( uin == contactList[ i ].uin )
                                            		{
                                            			return contactList[ i ];
                                            		}
                                            	}

                                            	CONTACT contact;
                                            	contact.uin = 0;
                                            	return contact;
                                            }


                                            /*
                                               ** 
                                               ** Update an entry
                                               ** Return 0 on success, -1 on error
                                            */
                                            int contact_updateContact( CONTACT update_contact )
                                            {
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( update_contact.uin == contactList[ i ].uin )
                                            		{
                                            			contactList[ i ] = update_contact;
                                            			return 0;
                                            		}
                                            	}

                                            	return - 1;
                                            }
                                            int contact_renameContact( UIN uin, const char *nick )
                                            {
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( uin == contactList[ i ].uin )
                                            		{
                                            			strcpy( contactList[ i ].nick, nick );
                                            			return 0;
                                            		}
                                            	}

                                            	return - 1;
                                            }

                                            int contact_deleteContact( UIN uin )
                                            {
                                            	int f = -1;
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( uin == contactList[ i ].uin )
                                            		{
                                            			f = i;
                                        			if ( contactList[ i ].awaymsg )
                                            				free( contactList[ i ].awaymsg );
                                            			continue;
                                            		}
                                            	}
                                        	if ( f > -1 )
                                            	{
                                        		for ( int i = f + 1; i <= contactNum; i++ )
                                            		{
                                            			contactList[ i - 1 ] = contactList[ i ];
                                            		}
                                            		contactNum--;
                                            		return 1;
                                            	}
                                            	return - 1;
                                            }

                                            char *contact_status2str( int status )
                                            {
                                        	switch ( status&0x1ff )
                                            	{
                                        		case 0x0:
                                            			// This MIGHT be DND..
                                        		case 0x10013:
                                        		case 0x10000:
                                            			// This MIGHT be N/A..
                                        		case 0x10005:
                                        		case 0x20000:
                                        		case 0x30000:
                                            			{
                                            				return "Available";
                                            				break;
                                            			}
                                        		case 0x1:
                                        		case 0x10001:
                                        		case 0x20001:
                                        		case 0x30001:
                                        		case 131585:
                                        		case 131584:
                                        		case 131588:
                                        		case 2294272:
                                        		case 66048:
                                        		case 512:
                                        		case 2293761:
                                        		case 2293765:
                                        		case 2293760:
                                        		case 2293762:
                                        		case 2293763:
                                        		case 2293764:
                                            			return "Away";
                                            			break;
                                        		case 0x5:
                                        		case 0x20005:
                                        		case 0x30005:
                                            			return "N/A";
                                            			break;
                                        		case 0x11:
                                        		case 0x20011:
                                        		case 0x30011:
                                            			return "Occupied";
                                            			break;
                                        		case 0x13:
                                        		case 0x20013:
                                        		case 0x30013:
                                            			return "DND";
                                            			break;
                                        		case 0x20:
                                        		case 0x20020:
                                        		case 0x30020:
                                            			return "Free for chat";
                                            			break;
                                        		case 0x100:
                                            			return "Invisible";
                                            			break;
                                                case -1:
                                                    return "Offline";
                                                    break;
                                        		default:
                                            			//char string[BUFSIZE];
                                            			char *string;
                                            			string = ( char * ) malloc( 20 );
                                            			sprintf( string, "Unknown(%d)", status );
                                            			return string;
                                            			break;
                                            	}

                                            	return '\0';
                                            }// contact_status2str


                                            char *getawaymsg()
                                            {
                                            	return user_config.awaymsg;
                                            }
                                            void setawaymsg( char *msg )
                                            {
                                        	if ( user_config.awaymsg )
                                            		free( user_config.awaymsg );
                                            	user_config.awaymsg = ( char * ) malloc( BUFSIZE );
                                            	strcpy( user_config.awaymsg, msg );
                                            }

                                            void contact_insertClas( UIN uin, void *clas )
                                            {
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( uin == contactList[ i ].uin )
                                            		{
                                        			if ( KXDEBUG ) printf( "insert %d - UIN %d %d\n", i, uin, !clas );
                                            			contactList[ i ].clas = clas;
                                            		}
                                            	}
                                            }
                                            void *contact_getClas( UIN uin )
                                            {
                                        	for ( int i = 0; i <= contactNum; i++ )
                                            	{
                                        		if ( uin == contactList[ i ].uin )
                                            		{
                                        			if ( KXDEBUG ) printf( "get %d - UIN %d %d\n", i, uin, !contactList[ i ].clas );
                                            			return contactList[ i ].clas;
                                            		}
                                            	}
                                            	return NULL;
                                            }
