/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* packets.h                                                               *
* Create packets                                                          *
**************************************************************************/


#ifndef _PACKETS_H
#define _PACKETS_H


#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "config.h"
#include "structs.h"
#include "contact.h"
#include "misc.h"
#include "v2_codes.h"


void packets_header( ICQ_PACKET &packet );
ICQ_PACKET packets_ack( int sequence );
ICQ_PACKET packets_msgAck( int sequence );
ICQ_PACKET packets_keepAlive();
ICQ_PACKET packets_login();
ICQ_PACKET packets_login_1();
ICQ_PACKET packets_add_user2list( UIN uin );
ICQ_PACKET packets_request_new_user( const char *passwd );
ICQ_PACKET packets_change_info( const char *email, const char *nick, const char *first, const char *last );
ICQ_PACKET packets_contactList();
ICQ_PACKET packets_messageS( unsigned int receiver, char *message );  // Msg to go through the server
ICQ_PACKET packets_urlS( unsigned int receiver, char *url, char *desc );
ICQ_PACKET packets_statusChange( unsigned int status );
ICQ_PACKET packets_uinSearch( unsigned int uin );
ICQ_PACKET packets_sendTextCode( char *textCode, unsigned short int X1 );
ICQ_PACKET packets_userSearch( const char *email, const char *nick, const char *first, const char *last, unsigned short int *t );
ICQ_PACKET packets_infoReply( unsigned int uin, unsigned short int *t );
ICQ_PACKET packets_extInfoReply( unsigned int uin, unsigned short int *t );
ICQ_PACKET packets_sendAuth( unsigned int uin);
ICQ_PACKET packets_web();
ICQ_PACKET packets_web_finisch();



#endif
