/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* parse.h                                                                 *
* Parse incomming packets                                                 *
**************************************************************************/


#ifndef _PARSE_H
#define _PARSE_H


#include <sys/time.h>
#include <iostream.h>
#include "config.h"
#include "structs.h"
#include "misc.h"
#include "ui2lib.h"
#include "contact.h"
#include "v2_codes.h"

void parse_S_LOGIN( ICQ_PACKET *packet );
int parse( ICQ_PACKET *packet );
void parse_S_new_user( ICQ_PACKET *packet );
void parse_S_USER_ONLINE( ICQ_PACKET *packet );
void parse_S_USER_OFFLINE( ICQ_PACKET *packet );
void parse_S_STATUS_UPDATE( ICQ_PACKET *packet );
void parse_S_GET_MESSAGE( ICQ_PACKET *packet, int online );
void parse_message( ICQ_PACKET *packet, int online );
void parse_url( ICQ_PACKET *packet, int online );
void parse_added( ICQ_PACKET *packet, int online );
void parse_auth( ICQ_PACKET *packet, int online );

void parse_S_USER_FOUND( ICQ_PACKET *packet );
void parse_S_INFO_REPLY( ICQ_PACKET *packet );
void parse_S_EXT_INFO_REPLY( ICQ_PACKET *packet );
int parseTCP( unsigned char *packet, int sock, int len );

void parse_TCP_CHAT( UIN seq, UIN uin, char *mesg );
void parse_ChatFunctions( int y );
#endif

