/**************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * ui2lib.cpp                                                              *
   * Functions the UI will call to send packages                             *
   **************************************************************************/


#include "ui2lib.h"
#include "libXicq.h"

extern CONTACT contactList[ MAXCONTACT ];
extern int contactNum;
extern NET_INFORMATION net_information;
extern USER_CONFIGURATION user_config;


int send_request_new_user( const char *passwd, USER_CONFIGURATION *user_cfg )
{
    if ( KXDEBUG )
        misc_log( "Sending request UIN packet." );

    if ( icq_init( user_cfg ) == -1 )
        return - 1;

    ICQ_PACKET packet;
    packet = packets_request_new_user( passwd );
    net_udpSend( packet.data, packet.length );
    return 0;
}
void send_change_info( const char *email, const char *nick, const char *first, const char *last )
{
    ICQ_PACKET packet;
    packet = packets_change_info( email, nick, first, last );
//    net_udpSend(packet.data, packet.length);
}

void send_login()
{
    if ( net_information.sock > 0 )
    {

        if ( KXDEBUG )
            misc_log( "Sending login packet." );

        ICQ_PACKET packet;
        packet = packets_login();
        net_udpSend( packet.data, packet.length );
    }
}

void send_login_1()
{
    if ( KXDEBUG )
        misc_log( "Sending login_1 packet." );

    ICQ_PACKET packet;
    packet = packets_login_1();
    net_udpSend( packet.data, packet.length );
}

void send_ack( int sequence )
{
    if ( KXDEBUG )
        misc_log( "Sending ack." );

    ICQ_PACKET packet;
    packet = packets_ack( sequence );
    net_udpSend( packet.data, packet.length );
}

void send_msgAck( int sequence )
{
    if ( KXDEBUG )
        misc_log( "Sending msgAck." );

    ICQ_PACKET packet;
    packet = packets_msgAck( sequence );
    net_udpSend( packet.data, packet.length );
}

void send_keepAlive()
{
    if ( KXDEBUG )
        misc_log( "Sending keep alive." );

    ICQ_PACKET packet;
    packet = packets_keepAlive();
    net_udpSend( packet.data, packet.length );
}

void send_contactList()
{
    if ( KXDEBUG )
        misc_log( "Sending contact list." );

    ICQ_PACKET packet;
    packet = packets_contactList();
    net_udpSend( packet.data, packet.length );
}
void send_web()
{
    if ( KXDEBUG )
        misc_log( "Sending Web presence." );

    ICQ_PACKET packet;
    packet = packets_web();
    net_udpSend( packet.data, packet.length );
}
void send_web_finisch()
{
    if ( KXDEBUG )
        misc_log( "Sending Web presence finisch." );

    ICQ_PACKET packet;
    packet = packets_web_finisch();
    net_udpSend( packet.data, packet.length );
}

void send_TCP_CHAT_ACCEPT( UIN seq, UIN receiver )
{
    if ( KXDEBUG )
        misc_log( "Sending chat accpet." );
    int y;
    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].uin == receiver )
        {
            if ( contactList[ y ].sock >= 0 )
            {
                net_TcpChatAcceptSend( y, seq );
            }
        }
    }
}


void send_message( int type, unsigned int receiver, char *message )
{
    if ( KXDEBUG )
        misc_log( "Sending message." );
    int send = 0;
    int y;
    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].uin == receiver )
        {
            if ( contactList[ y ].status != STATUS_OFFLINE && type != SEND_TRUE_SERVER )
            {
                if ( contactList[ y ].sock == -1 )
                    tcp_openConnection( contactList[ y ].uin );
                if ( contactList[ y ].sock == -1 )
                {
                    ICQ_PACKET packet;
                    packet = packets_messageS( receiver, message );
                    net_udpSend( packet.data, packet.length );
                    send = 1;
                }
                else
                {
                    if ( net_tcpSend( ( unsigned char * ) message, TCP_MSG, y, TCP_START, 0 ) < 0 )
                    {
                        ICQ_PACKET packet;
                        packet = packets_messageS( receiver, message );
                        net_udpSend( packet.data, packet.length );
                        send = 1;
                    }
                    send = 1;
                }
            }
            else
            {
                ICQ_PACKET packet;
                packet = packets_messageS( receiver, message );
                net_udpSend( packet.data, packet.length );
                send = 1;
            }
        }
    }
    if ( send == 0 )
    {
        ICQ_PACKET packet;
        packet = packets_messageS( receiver, message );
        net_udpSend( packet.data, packet.length );
    }
}

void send_askAway( UIN uin )
{
    int y;
    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].uin == uin )
        {
            if ( contactList[ y ].sock == -1 )
                tcp_openConnection( contactList[ y ].uin );
            if ( contactList[ y ].sock == -1 )
            {
                return;
            }
            else
            {
                unsigned char *message;
                message = ( unsigned char * ) malloc( BUFSIZE + 1 );
                net_tcpSend( ( unsigned char * ) message, TCP_READAWAYMSG, y, TCP_START, 0 );
                free( message );
            }
        }
    }
}

void send_url( int type, unsigned int receiver, char *url, char *desc )
{
    if ( KXDEBUG )
        misc_log( "Sending url." );
    int send = 0;
    int y;
    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].uin == receiver )
        {
            if ( contactList[ y ].status != STATUS_OFFLINE && type != SEND_TRUE_SERVER )
            {
                if ( contactList[ y ].sock == -1 )
                    tcp_openConnection( contactList[ y ].uin );
                if ( contactList[ y ].sock == -1 )
                {
                    ICQ_PACKET packet;
                    packet = packets_urlS( receiver, url, desc );
                    net_udpSend( packet.data, packet.length );
                    send = 1;
                }
                else
                {
                    char message[ BUFSIZE ];
                    int t, tt = 0;
                    for ( t = 0; t < ( int ) strlen( ( char * ) desc ); t++ )
                        message[ tt++ ] = desc[ t ];
                    message[ tt++ ] = 0xFE;
                    for ( t = 0; t < ( int ) strlen( ( char * ) url ); t++ )
                        message[ tt++ ] = url[ t ];
                    message[ tt ] = 0;
                    if ( net_tcpSend( ( unsigned char * ) message, TCP_URL, y, TCP_START, 0 ) < 0 )
                    {
                        ICQ_PACKET packet;
                        packet = packets_urlS( receiver, url, desc );
                        net_udpSend( packet.data, packet.length );
                    }
                    send = 1;
                }
            }
            else
            {
                ICQ_PACKET packet;
                packet = packets_urlS( receiver, url, desc );
                net_udpSend( packet.data, packet.length );
                send = 1;
            }
        }
    }
    if ( send == 0 )
    {
        ICQ_PACKET packet;
        packet = packets_urlS( receiver, url, desc );
        net_udpSend( packet.data, packet.length );
    }
}

void send_statusChange( unsigned int status )
{
    if ( KXDEBUG )
        misc_log( "Sending status change." );

    ICQ_PACKET packet;
    packet = packets_statusChange( status );
    net_udpSend( packet.data, packet.length );

    user_config.status = status;
}

int status_str2num( char *str )
{
    int tmp;
    int _status;

    tmp = strtol( str, NULL, 0 );

    switch ( tmp )
    {

        case 0: // Available
            _status = STATUS_ONLINE;
            break;
        case 1: // Away
            _status = STATUS_AWAY;
            break;
        case 2: // Do Not Desturb (DND)
            _status = STATUS_DND;
            break;
        case 3: // N/A
            _status = STATUS_NA;
            break;
        case 4: // Occupied
            _status = STATUS_OCCUPIED;
            break;
        case 5: // Free For Chat
            _status = STATUS_FFC;
            break;
        case 6: // Invisible
            _status = STATUS_INVISIBLE;
            break;
        default: // Something else?
            _status = -1;
    }
    // Add some code here to handle the case of the user inputting a string.
    return _status;
}

void send_uinSearch( unsigned int uin )
{
    if ( KXDEBUG )
        misc_log( "Sending UIN search." );

    ICQ_PACKET packet;
    packet = packets_uinSearch( uin );
    net_udpSend( packet.data, packet.length );
}

unsigned short int send_infoReply( unsigned int uin )
{
    ICQ_PACKET packet;

    unsigned short int t;
    packet = packets_infoReply( uin, &t );
    net_udpSend( packet.data, packet.length );
    return t;
}
unsigned short int send_extInfoReply( unsigned int uin )
{
    ICQ_PACKET packet;
    unsigned short int t;
    packet = packets_extInfoReply( uin, &t );
    net_udpSend( packet.data, packet.length );
    return t;
}
void send_auth( unsigned int uin )
{
    ICQ_PACKET packet;
    packet = packets_sendAuth( uin);
    net_udpSend( packet.data, packet.length );
}



unsigned short int send_userSearch( const char* email, const char* nick, const char* first, const char* last )
{
    if ( KXDEBUG )
        misc_log( "Sending USER search." );

    ICQ_PACKET packet;
    unsigned short int t;
    packet = packets_userSearch( email, nick, first, last, &t );
    net_udpSend( packet.data, packet.length );
    if ( KXDEBUG ) printf( "seqS: %d\n", t );
    return t;
}

void send_logout()
{
    if ( net_information.sock > 0 )
    {

        if ( KXDEBUG )
            misc_log( "Sending logout packet." );

        ICQ_PACKET packet;
        packet = packets_sendTextCode( "B_USER_DISCONNECTED", 5 );
        net_udpSend( packet.data, packet.length );
        if ( net_information.sock > 0 ) close( net_information.sock );
        if ( net_information.tcpsock > 0 ) close( net_information.tcpsock );
        net_information.tcpsock = -1;
        net_information.sock = -1;
        int y;
        for ( y = 0; y <= contactNum; y++ )
        {
            contactList[ y ].status = STATUS_OFFLINE;
            if ( contactList[ y ].sock > 0 )
            {
                close( contactList[ y ].sock );
                contactList[ y ].sock = -1;
            }
            if ( contactList[ y ].listensock > 0 )
            {
                close( contactList[ y ].listensock );
                contactList[ y ].listensock = -1;
            }
            if ( contactList[ y ].chatsock > 0 )
            {
                close( contactList[ y ].chatsock );
                contactList[ y ].chatsock = -1;
            }
        }
    }
}

char *returnMyStatus()
            {
                return ( contact_status2str( user_config.status ) );
            }

            int send_Chat( UIN uin, char *data, int len )
            {
            for ( int i = 0; i <= contactNum; i++ )
                {
                if ( uin == contactList[ i ].uin )
                    {
                        int y = net_send2chat( contactList[ i ].listensock, data, len );
                    if ( y < 0 )
                        {
                            contactList[ i ].server = 0;
                            contactList[ i ].active = 0;
                        }
                        return y;
                    }
                }
                return 0;
            }

            int send_chatRequest( UIN uin, char *mesg )
            {
            for ( int i = 0; i <= contactNum; i++ )
                {
                if ( uin == contactList[ i ].uin )
                    {
                    if ( contactList[ i ].sock == -1 )
                            tcp_openConnection( contactList[ i ].uin );
                    if ( contactList[ i ].sock != -1 )
                        {
                            int y;
                            y = net_sendRequest( i, mesg );
                        if ( y != -1 )
                            {
                                contactList[ i ].server = 2;
                                contactList[ i ].active = 0;
                            }
                            return y;
                        }
                    }
                }
                return - 1;
            }

            int chat_close( UIN uin )
            {
            for ( int i = 0; i <= contactNum; i++ )
                {
                if ( uin == contactList[ i ].uin )
                    {
                    if ( KXDEBUG ) printf( "close char \n" );
                        contactList[ i ].clas = NULL;
                        close( contactList[ i ].listensock );
                        contactList[ i ].listensock = -1;
                        contactList[ i ].server = 0;
                        contactList[ i ].active = 0;
                        return 0;
                    }
                }
                return - 1;
            }

            int send_chatAccept( UIN uin )
            {
            for ( int i = 0; i <= contactNum; i++ )
                {
                if ( uin == contactList[ i ].uin )
                    {
                        send_TCP_CHAT_ACCEPT( contactList[ i ].chatseq, uin );
                    }
                }
                return 0;
            }
            int send_chatCancel( UIN uin, char *mesg )
            {
            for ( int i = 0; i <= contactNum; i++ )
                {
                if ( uin == contactList[ i ].uin )
                    {
                        net_sendChatCancel( i );
                    }
                }
                return 0;
            }


