/*
   $Id: users.cpp,v 2.25.4.1.2.3 1998/12/20 21:01:59 herwinjs Exp $
*/

#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <kiconloader.h>
#include <qwmatrix.h>
#include <qrect.h>
#include <qwmatrix.h>
#include <qpicture.h>
#include <qdict.h>
#include <qintdict.h>
#include "kxicq.h"
#include "dialogs.h"
#include "sendDialog.h"

#define ID_POPUP_MSG 1
#define ID_POPUP_CHAT 2
#define ID_POPUP_INFO 3
#define ID_POPUP_DELETE 4
#define ID_POPUP_ADD 5

extern struct kxicqConfig KxicqConfig;
extern int logged_on;
extern mainWin *mainW;
extern KApplication *mainApp;
extern QList < MSG > userMsg;
viewSearch *viewS;
userInfo *userI;
int isViewSearch ;
int isDoSearch ;
int stopAll;
extern DockView *dockView;
int showOffline = 2;  //type of windows layout, 0 = only offline, 1 = old KXicq style, 2 = m$icq style
int OldStyle = 1;
extern USER_CONFIGURATION user_cfg;

Users::Users( QWidget* parent, const char* name )
        : QWidget( parent, name )
{
    split = new QSplitter( this );

    wa=new QWidget(split);
    wo=new QWidget(split);
    
    vb=new QVBoxLayout(wa);

    QLabel *l=new QLabel(wa);
    l->setText(i18n("Online Users"));
    l->setFixedHeight(20);
    l->setFrameStyle( QFrame::Raised | QFrame::Panel );
    vb->addWidget(l);
    
    avail = new userView( VIEW_ONLINE, wa );
    vb->addWidget(avail);
    vb->activate();

    vb=new QVBoxLayout(wo);

    l=new QLabel(wo);
    l->setText(i18n("Offline Users"));
    l->setFixedHeight(20);
    l->setFrameStyle( QFrame::Raised | QFrame::Panel );
    vb->addWidget(l);

    offl = new userView( VIEW_OFFLINE, wo );
    vb->addWidget(offl);
    vb->activate();
}

Users::~Users()
{
    delete offl;
    delete avail;
}

int Users::getView()
{
    return OldStyle;
}

void Users::setNewView( int s )
{
    switch ( s )
    {
        case 1:
            setOldStyle();
            break;
        case 2:
            setMSStyle();
            break;
        case 3:
            setOnlineOnly();
            break;
    }
    resize(width(), height() );
    mainW->resize(mainW->width(), mainW->height() );
    update();
}

void Users::setOldStyle()
{
    hide();
    setMSStyle();
    
    split->setOrientation( QSplitter::Horizontal );
    mainW->setMinimumSize( 385, 200 );
    update();

    wo->setMaximumHeight( 4000 );
    wa->setMaximumHeight( 4000 );
    wo->resize((this->width()/2), this->height());
    wa->resize((this->width()/2), this->height());
    update();

    split->resize(this->width(), this->height());
    update();
    
    OldStyle=1;
    show();
}

void Users::setMSStyle()
{
    hide();
    
    split->setOrientation( QSplitter::Vertical );
    mainW->setMinimumSize( 195, 200 );
    update();

    wo->setMaximumHeight( 4000 );
    wa->setMaximumHeight( 4000 );
    wo->resize(this->width(), (this->height()/2));
    wa->resize(this->width(), (this->height()/2));
    update();
    
    split->resize(this->width(),this->height());
    update();
    show();
    OldStyle=2;
}

void Users::setOnlineOnly()
{
    hide();

    split->setOrientation( QSplitter::Vertical );
    mainW->setMinimumSize( 195, 200 );
    update();

    wo->resize( this->width(), 1 );
    wa->resize( this->width(), this->height()-1 );
    wa->setMaximumHeight( 4000 );
    wo->setMaximumHeight( 1 );
    update();

    split->resize(this->width(),this->height());
    update();
    show();
    OldStyle=3;
}

void Users::unSelectAll( int t )
{
    if ( t == 0 )
    {
        //      offl->unmarkAll();
    }
    else
    {
        //      avail->unmarkAll();
    }
}

void Users::highlight1( int, int )
{
    //   avail->unmarkAll();
}
void Users::highlight2( int, int )
{
    //   offl->unmarkAll();
}
void Users::insertItem( UIN status, QString nick, UIN uin, int r, int ir )
{
    offl->changeItem( uin );
    avail->changeItem( uin );
}

void Users::changeItem( UIN uin )
{

    offl->changeItem( uin );
    avail->changeItem( uin );
}

void Users::changeNick( UIN uin, char *nick, int status )
{
    offl->changeItem( uin );
    avail->changeItem( uin );
}

int Users::addItem( UIN uin )
{
    offl->changeItem( uin );
    avail->changeItem( uin );
    return 1;
}

void Users::doSetUnRead( UIN uin )
{
    offl->changeItem( uin );
    avail->changeItem( uin );
}

bool Users::eventFilter( QObject *obj, QEvent *event )
{
    return TRUE;
}

void Users::updateView()
{
    //offl->changeItem( uin );
    //avail->changeItem( uin );
    repaint();
}

void Users::mousePressEvent( QMouseEvent *m )
{
}
void Users::doMouseEvent( QMouseEvent * )
{
}
void Users::resizeEvent( QResizeEvent * e)
{
    QWidget::resizeEvent( e );
    split->resize( width(), height() );
    update();
    QWidget::resizeEvent( e );
}
